package cn.com.duiba.scrm.center.api.dto.role;

import java.io.Serializable;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName UserRolejava
 * @Description TODO
 * @createTime 2021年07月20日 20:02:00
 */
public class UserRoleDetailDto implements Serializable {
    private static final long serialVersionUID = 5852566378291673439L;

    /**
     * 角色ID
     */
    private Long scRoleId;

    /**
     * 用户id
     * =sc_wechat_user.id
     */
    private Long scWechatUserId;
    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 企业Id
     */
    private Long scCorpId;

    /**
     * 角色等级0:超级管理员 1:普通管理员 2部门管理员 3一线员工
     */
    private Integer roleLevel;

    /**
     * 显示顺序
     */
    private Integer roleSort;

    /**
     * 角色状态（0正常 1停用 2删除）
     */
    private Integer roleStatus;

    /**
     * 创建者
     */
    private Long createBy;

    /**
     * 该角色的管理部门列表,分割
     */
    private String manageDeptIdStr;

    public Long getScRoleId() {
        return scRoleId;
    }

    public void setScRoleId(Long scRoleId) {
        this.scRoleId = scRoleId;
    }

    public Long getScWechatUserId() {
        return scWechatUserId;
    }

    public void setScWechatUserId(Long scWechatUserId) {
        this.scWechatUserId = scWechatUserId;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Long getScCorpId() {
        return scCorpId;
    }

    public void setScCorpId(Long scCorpId) {
        this.scCorpId = scCorpId;
    }

    public Integer getRoleLevel() {
        return roleLevel;
    }

    public void setRoleLevel(Integer roleLevel) {
        this.roleLevel = roleLevel;
    }

    public Integer getRoleSort() {
        return roleSort;
    }

    public void setRoleSort(Integer roleSort) {
        this.roleSort = roleSort;
    }

    public Integer getRoleStatus() {
        return roleStatus;
    }

    public void setRoleStatus(Integer roleStatus) {
        this.roleStatus = roleStatus;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public String getManageDeptIdStr() {
        return manageDeptIdStr;
    }

    public void setManageDeptIdStr(String manageDeptIdStr) {
        this.manageDeptIdStr = manageDeptIdStr;
    }


    public UserRoleDetailDto() {
    }

    public UserRoleDetailDto(RoleDto roleDto, UserRoleDto userRoleDto) {
        this();
        setScRoleId(userRoleDto.getScRoleId());
        setScWechatUserId(userRoleDto.getScWechatUserId());

        setScCorpId(userRoleDto.getScRoleId());

        setCreateBy(userRoleDto.getCreateBy());
        setManageDeptIdStr(userRoleDto.getManageDeptIdStr());

        setRoleName(roleDto.getRoleName());
        setRoleLevel(roleDto.getRoleLevel());
        setRoleSort(roleDto.getRoleSort());
        setRoleStatus(roleDto.getRoleStatus());
    }
}
