package cn.com.duiba.scrm.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.tag.TagDto;
import cn.com.duiba.scrm.center.api.param.TagDeleteParam;
import cn.com.duiba.scrm.center.api.param.TagEditParam;
import cn.com.duiba.scrm.center.api.param.TagQueryParam;
import cn.com.duiba.scrm.center.api.param.TagSaveParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 企业微信标签 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 19:23:53
 */
@AdvancedFeignClient
public interface RemoteTagService {
    /**
     * 新增记录
     */
    Boolean save(TagDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(TagDto dto);

    /**
     * 根据id获取
     */
    TagDto getById(Long id);

    List<TagDto> getByIds(List<Long> ids);

    List<TagDto> getByTagIds(Long scCorpId, List<String> tagIds);


    ScrmResult<ScrmPageResult<TagDto>> queryPage(TagQueryParam queryParam);


    /**
     * 以下三个接口均为先调用微信接口，再进行标签同步
     *
     * @param param
     * @return
     */
    ScrmResult<Boolean> addTag(TagSaveParam param);

    ScrmResult<Boolean> editTag(TagEditParam param);

    ScrmResult<Boolean> delTag(TagDeleteParam param);
}
