package cn.com.duiba.scrm.center.api.dto.groupmsg;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 群发成员执行结果
* 2021-7-30 13:39:38
*/
@Data
public class GroupMsgSendResultDto implements Serializable {

    /**
    * 外部客户群id，群发消息到客户不返回该字段
    */
    private String chatId;

    /**
    * 外部联系人userid，群发消息到企业的客户群不返回该字段
    */
    private String externalUserid;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;

    /**
    * 主键id，自增
    */
    private Long id;

    /**
    * 企业群发消息id
    */
    private String msgId;

    /**
    * 发送状态：0-未发送 1-已发送 2-因客户不是好友导致发送失败 3-因客户已经收到其他群发消息导致发送失败
    */
    private Integer sendStatus;

    /**
    * 发送时间，发送状态为1时返回
    */
    private Date sendTime;

    /**
    * 关联 sc_group_msg id
    */
    private Long taskId;

    /**
    * 成员id或群主id
    */
    private String userId;


}

