package cn.com.duiba.scrm.center.api.dto.role;

import cn.com.duiba.scrm.center.api.dto.base.BaseDto;
import cn.com.duiba.scrm.center.api.enums.RoleLevelEnum;

import java.util.Date;
import java.util.Objects;

/**
 * 角色信息表
 * 2021-7-16 22:47:19
 */
public class RoleDto implements BaseDto {

    private static final long serialVersionUID = -949653759667267034L;
    /**
     * 角色ID
     */
    private Long id;

    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 企业Id
     */
    private Long scCorpId;

    /**
     * 角色等级0:超级管理员 1:普通管理员 2部门管理员 3一线员工
     */
    private Integer roleLevel;

    /**
     * 显示顺序
     */
    private Integer roleSort;

    /**
     * 角色状态（0正常 1停用 2删除）
     */
    private Integer roleStatus;

    /**
     * 创建者
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;


    public boolean isAdmin() {
        return Objects.equals(roleLevel, RoleLevelEnum.ROOT_MANAGER.getLevel());
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Long getScCorpId() {
        return scCorpId;
    }

    public void setScCorpId(Long scCorpId) {
        this.scCorpId = scCorpId;
    }

    public Integer getRoleLevel() {
        return roleLevel;
    }

    public void setRoleLevel(Integer roleLevel) {
        this.roleLevel = roleLevel;
    }

    public Integer getRoleSort() {
        return roleSort;
    }

    public void setRoleSort(Integer roleSort) {
        this.roleSort = roleSort;
    }

    public Integer getRoleStatus() {
        return roleStatus;
    }

    public void setRoleStatus(Integer roleStatus) {
        this.roleStatus = roleStatus;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

