package cn.com.duiba.scrm.center.api.dto.user;

import cn.com.duiba.scrm.center.api.dto.base.BaseDto;
import cn.com.duiba.scrm.center.api.enums.UserStatusEnum;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.user.WeUserResult;
import com.alibaba.fastjson.JSON;

import java.util.Date;

/**
 * 通讯录成员表
 * 2021-7-17 10:34:06
 */
public class WechatUserDto implements BaseDto {

    private static final long serialVersionUID = 1172737806475342219L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 微信成员UserID。对应管理端的帐号
     */
    private String userId;

    /**
    * 微信open_userid,全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的open_userid是相同的
    */
    private String openUserid;

    /**
    * 头像地址
    */
    private String headImageUrl;

    /**
    * 用户名称
    */
    private String userName;

    /**
    * 用户昵称
    */
    private String userAlias;

    /**
    * 性别。1表示男性，2表示女性
    */
    private Integer userGender;

    /**
    * 手机号
    */
    private String userMobile;

    /**
    * 邮箱
    */
    private String userEmail;

    /**
    * 用户所属部门,使用逗号隔开,字符串格式存储
    */
    private String userDepartment;

    /**
    * 职务
    */
    private String userPosition;

    /**
    * 1表示为上级,0表示普通成员(非上级)。
    */
    private String isLeaderInDept;

    /**
    * 座机
    */
    private String userTelephone;

    /**
    * 地址
    */
    private String userAddress;

    /**
     * 状态 ：0：删除 1：开启
     * {@link UserStatusEnum}
     */
    private Integer userStatus;

    /**
    * 企业ID
    */
    private Long scCorpId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


    public static WechatUserDto convert(Long scCorpId, WeUserResult weUserResult) {
        WechatUserDto wechatUserDto = new WechatUserDto();
        wechatUserDto.setHeadImageUrl(weUserResult.getAvatar());
        wechatUserDto.setIsLeaderInDept(JSON.toJSONString(weUserResult.getIsLeaderInDept()));
        wechatUserDto.setOpenUserid(weUserResult.getOpenUserId());
        wechatUserDto.setScCorpId(scCorpId);
        wechatUserDto.setUserAddress(weUserResult.getAddress());
        wechatUserDto.setUserAlias(weUserResult.getAlias());
        wechatUserDto.setUserDepartment(JSON.toJSONString(weUserResult.getDepartment()));
        wechatUserDto.setUserEmail(weUserResult.getEmail());
        wechatUserDto.setUserGender(weUserResult.getGender());
        wechatUserDto.setUserId(weUserResult.getUserId());
        wechatUserDto.setUserMobile(weUserResult.getMobile());
        wechatUserDto.setUserName(weUserResult.getName());
        wechatUserDto.setUserPosition(weUserResult.getPosition());
        wechatUserDto.setUserTelephone(weUserResult.getTelephone());
        wechatUserDto.setUserStatus(UserStatusEnum.OPEN.getType());
        return wechatUserDto;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOpenUserid() {
        return openUserid;
    }

    public void setOpenUserid(String openUserid) {
        this.openUserid = openUserid;
    }

    public String getHeadImageUrl() {
        return headImageUrl;
    }

    public void setHeadImageUrl(String headImageUrl) {
        this.headImageUrl = headImageUrl;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserAlias() {
        return userAlias;
    }

    public void setUserAlias(String userAlias) {
        this.userAlias = userAlias;
    }

    public Integer getUserGender() {
        return userGender;
    }

    public void setUserGender(Integer userGender) {
        this.userGender = userGender;
    }

    public String getUserMobile() {
        return userMobile;
    }

    public void setUserMobile(String userMobile) {
        this.userMobile = userMobile;
    }

    public String getUserEmail() {
        return userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserDepartment() {
        return userDepartment;
    }

    public void setUserDepartment(String userDepartment) {
        this.userDepartment = userDepartment;
    }

    public String getUserPosition() {
        return userPosition;
    }

    public void setUserPosition(String userPosition) {
        this.userPosition = userPosition;
    }

    public String getIsLeaderInDept() {
        return isLeaderInDept;
    }

    public void setIsLeaderInDept(String isLeaderInDept) {
        this.isLeaderInDept = isLeaderInDept;
    }

    public String getUserTelephone() {
        return userTelephone;
    }

    public void setUserTelephone(String userTelephone) {
        this.userTelephone = userTelephone;
    }

    public String getUserAddress() {
        return userAddress;
    }

    public void setUserAddress(String userAddress) {
        this.userAddress = userAddress;
    }

    public Integer getUserStatus() {
        return userStatus;
    }

    public void setUserStatus(Integer userStatus) {
        this.userStatus = userStatus;
    }

    public Long getScCorpId() {
        return scCorpId;
    }

    public void setScCorpId(Long scCorpId) {
        this.scCorpId = scCorpId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

