package cn.com.duiba.scrm.center.api.param.customer;

import cn.com.duiba.scrm.center.api.param.BaseOperateParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2021/7/26 12:53
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerQueryParam extends BaseOperateParam {

    /**
     * 添加开始时间
     */
    private Date addStartTime;

    /**
     * 添加结束时间
     */
    private Date addEndTime;

    /**
     * 名字
     */
    private String name;

    /**
     * 性别 性别 0-未知 1-男性 2-女性
     */
    private Integer gender;

    /**
     * 所属员工
     */
    private List<Long> userIds;

    /**
     * 部门Id列表
     */
    private List<Long> departmentIds;

    /**
     * 标签列表
     */
    private List<Long> tagIds;

    /**
     * 流失状态
     */
    private Integer loseStatus;

    /**
     * 群聊列表Id
     */
    private List<String> chatGroupIds;

    /**
     * 添加渠道 1：个人活码Id 2：群活码Id
     */
    private Long addWay;


    private Long scCorpId;
}
