package cn.com.duiba.scrm.center.api.remoteservice.code;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.code.EmpleCodeGroupDto;
import cn.com.duiba.scrm.center.api.param.code.ChangeCodeGroupStatusParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 员工活码-群信息表 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 10:30:32
 */
@AdvancedFeignClient
public interface RemoteEmpleCodeGroupService {
    /**
     * 新增记录
     */
    Boolean save(EmpleCodeGroupDto dto);

    /**
     * 根据id删除
     */
    ScrmResult<Boolean> deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(EmpleCodeGroupDto dto);

    /**
     * 根据id获取
     */
    EmpleCodeGroupDto getById(Long id);

    /**
     * 根据id失效
     *
     * @param id
     * @return
     */
    ScrmResult<Boolean> loseEffect(Long id);

    /**
     * 根据活码ID查询群聊列表
     *
     * @param codeId
     * @return
     */
    ScrmResult<List<EmpleCodeGroupDto>> getByCodeId(Long codeId);

    /**
     * 获取符合信息的列表
     *
     * @param empleCodeGroupDto
     * @return
     */
    ScrmResult<List<EmpleCodeGroupDto>> getByDto(EmpleCodeGroupDto empleCodeGroupDto);

    /**
     * 更改群聊状态
     *
     * @param param
     * @return
     */
    ScrmResult<Integer> changeStatus(ChangeCodeGroupStatusParam param);


}
