package cn.com.duiba.scrm.center.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.customer.WechatCustomerDto;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
* 企业微信客户表 RemoteService
* @author xiaotian
* 2021-7-23 15:35:19
*/
@AdvancedFeignClient
public interface RemoteWechatCustomerService {
    /**
    * 新增记录
    */
	Long save(WechatCustomerDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(WechatCustomerDto dto);
    /**
    * 根据id获取
    */
    WechatCustomerDto getById(Long id);


    /**
     * 通过企业Id和客户id列表获取
     *
     * @param scCorpId
     * @param customerIds
     * @return
     */
    List<WechatCustomerDto> getByCorpIdAndIds(Long scCorpId, List<Long> customerIds);


    /**
     * 通过企业Id和客户id列表获取
     *
     * @param scCorpId
     * @param customerIds
     * @return
     */
    List<WechatCustomerDto> getByCorpIdAndCustomerUserIds(Long scCorpId, List<String> customerIds);

    /**
     * 通过外部联系人的userid查询
     *
     * @param externalUserId
     * @return
     */
    ScrmResult<WechatCustomerDto> getByExternalUserId(String externalUserId);
}
