package cn.com.duiba.scrm.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.user.WechatUserDto;
import cn.com.duiba.scrm.center.api.param.wechatUser.WechatUserPageQuery;
import cn.com.duiba.scrm.common.result.ScrmPageResult;

import java.util.List;

/**
* 通讯录成员表 RemoteService
* @author xiaotian
* 2021-7-17 10:34:06
*/
@AdvancedFeignClient
public interface RemoteWechatUserService {
    /**
    * 新增记录
    */
	Long save(WechatUserDto dto);

    /**
    * 根据id更新
    */
    Boolean updateById(WechatUserDto dto);
    /**
    * 根据id获取
    */
    WechatUserDto getById(Long id);

    /**
     * 通过成员Id和企业Id，获取唯一成员记录
     * @param scCorpId
     * @param userId
     * @return
     */
    WechatUserDto getByCorpIdAndUserId(Long scCorpId, String userId);


    /**
     * 通过成员Id的列表和企业Id，获取记录列表
     *
     * @param scCorpId
     * @param wechatUserIds
     * @return
     */
    List<WechatUserDto> getByCorpIdAndIds(Long scCorpId, List<Long> wechatUserIds);

    List<WechatUserDto> getByCorpIdAndUserIds(Long scCorpId, List<String> userIds);


    /**
     * 筛选员工列表
     *
     * @param wechatUserPageQuery
     * @return
     */
    ScrmPageResult<WechatUserDto> queryPage(WechatUserPageQuery wechatUserPageQuery);


    /**
     * 根据成员
     */
    Boolean deleteUser(Long id);

}
