/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.center.api.dto.customer;

import cn.com.duiba.scrm.common.enums.wechat.DuibaTagEnum;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.ExternalUserDetailResult;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class UserCustomerRelDto
implements Serializable {
    private Long id;
    private Long scUserId;
    private Long wechatCustomerId;
    private String customerUserId;
    private String customerRemark;
    private String customerDescription;
    private String remarkCorpName;
    private String remarkMobiles;
    private String operUserid;
    private Integer addWay;
    private String linkState;
    private Integer relStatus;
    private Date leaveTime;
    private Long scCorpId;
    private Date gmtCreate;
    private Date gmtModified;

    public static UserCustomerRelDto convert(ExternalUserDetailResult.FollowUser followUser) {
        UserCustomerRelDto userCustomerRelDto = new UserCustomerRelDto();
        userCustomerRelDto.setAddWay(followUser.getAddWay());
        userCustomerRelDto.setCustomerDescription(followUser.getDescription());
        userCustomerRelDto.setCustomerRemark(followUser.getRemark());
        userCustomerRelDto.setRemarkMobiles(JSON.toJSONString((Object)followUser.getRemarkMobiles()));
        userCustomerRelDto.setOperUserid(followUser.getOperUserid());
        userCustomerRelDto.setRemarkCorpName(followUser.getRemarkCorpName());
        String state = followUser.getState();
        if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith(DuibaTagEnum.DUIBA.getTag())) {
            userCustomerRelDto.setLinkState(state);
        } else {
            userCustomerRelDto.setLinkState("other");
        }
        userCustomerRelDto.setGmtCreate(new Date(followUser.getCreatetime() * 1000L));
        return userCustomerRelDto;
    }

    public static UserCustomerRelDto convert(ExternalUserDetailResult.FollowInfo followInfo) {
        UserCustomerRelDto userCustomerRelDto = new UserCustomerRelDto();
        userCustomerRelDto.setAddWay(followInfo.getAdd_way());
        userCustomerRelDto.setCustomerDescription(followInfo.getDescription());
        userCustomerRelDto.setCustomerRemark(followInfo.getRemark());
        userCustomerRelDto.setRemarkMobiles(JSON.toJSONString((Object)followInfo.getRemark_mobiles()));
        userCustomerRelDto.setOperUserid(followInfo.getOper_userid());
        userCustomerRelDto.setRemarkCorpName(followInfo.getRemark_company());
        String state = followInfo.getState();
        if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith(DuibaTagEnum.DUIBA.getTag())) {
            userCustomerRelDto.setLinkState(state);
        } else {
            userCustomerRelDto.setLinkState("other");
        }
        userCustomerRelDto.setGmtCreate(new Date(followInfo.getCreatetime() * 1000L));
        return userCustomerRelDto;
    }

    public Long getId() {
        return this.id;
    }

    public Long getScUserId() {
        return this.scUserId;
    }

    public Long getWechatCustomerId() {
        return this.wechatCustomerId;
    }

    public String getCustomerUserId() {
        return this.customerUserId;
    }

    public String getCustomerRemark() {
        return this.customerRemark;
    }

    public String getCustomerDescription() {
        return this.customerDescription;
    }

    public String getRemarkCorpName() {
        return this.remarkCorpName;
    }

    public String getRemarkMobiles() {
        return this.remarkMobiles;
    }

    public String getOperUserid() {
        return this.operUserid;
    }

    public Integer getAddWay() {
        return this.addWay;
    }

    public String getLinkState() {
        return this.linkState;
    }

    public Integer getRelStatus() {
        return this.relStatus;
    }

    public Date getLeaveTime() {
        return this.leaveTime;
    }

    public Long getScCorpId() {
        return this.scCorpId;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setScUserId(Long scUserId) {
        this.scUserId = scUserId;
    }

    public void setWechatCustomerId(Long wechatCustomerId) {
        this.wechatCustomerId = wechatCustomerId;
    }

    public void setCustomerUserId(String customerUserId) {
        this.customerUserId = customerUserId;
    }

    public void setCustomerRemark(String customerRemark) {
        this.customerRemark = customerRemark;
    }

    public void setCustomerDescription(String customerDescription) {
        this.customerDescription = customerDescription;
    }

    public void setRemarkCorpName(String remarkCorpName) {
        this.remarkCorpName = remarkCorpName;
    }

    public void setRemarkMobiles(String remarkMobiles) {
        this.remarkMobiles = remarkMobiles;
    }

    public void setOperUserid(String operUserid) {
        this.operUserid = operUserid;
    }

    public void setAddWay(Integer addWay) {
        this.addWay = addWay;
    }

    public void setLinkState(String linkState) {
        this.linkState = linkState;
    }

    public void setRelStatus(Integer relStatus) {
        this.relStatus = relStatus;
    }

    public void setLeaveTime(Date leaveTime) {
        this.leaveTime = leaveTime;
    }

    public void setScCorpId(Long scCorpId) {
        this.scCorpId = scCorpId;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserCustomerRelDto)) {
            return false;
        }
        UserCustomerRelDto other = (UserCustomerRelDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$scUserId = this.getScUserId();
        Long other$scUserId = other.getScUserId();
        if (this$scUserId == null ? other$scUserId != null : !((Object)this$scUserId).equals(other$scUserId)) {
            return false;
        }
        Long this$wechatCustomerId = this.getWechatCustomerId();
        Long other$wechatCustomerId = other.getWechatCustomerId();
        if (this$wechatCustomerId == null ? other$wechatCustomerId != null : !((Object)this$wechatCustomerId).equals(other$wechatCustomerId)) {
            return false;
        }
        String this$customerUserId = this.getCustomerUserId();
        String other$customerUserId = other.getCustomerUserId();
        if (this$customerUserId == null ? other$customerUserId != null : !this$customerUserId.equals(other$customerUserId)) {
            return false;
        }
        String this$customerRemark = this.getCustomerRemark();
        String other$customerRemark = other.getCustomerRemark();
        if (this$customerRemark == null ? other$customerRemark != null : !this$customerRemark.equals(other$customerRemark)) {
            return false;
        }
        String this$customerDescription = this.getCustomerDescription();
        String other$customerDescription = other.getCustomerDescription();
        if (this$customerDescription == null ? other$customerDescription != null : !this$customerDescription.equals(other$customerDescription)) {
            return false;
        }
        String this$remarkCorpName = this.getRemarkCorpName();
        String other$remarkCorpName = other.getRemarkCorpName();
        if (this$remarkCorpName == null ? other$remarkCorpName != null : !this$remarkCorpName.equals(other$remarkCorpName)) {
            return false;
        }
        String this$remarkMobiles = this.getRemarkMobiles();
        String other$remarkMobiles = other.getRemarkMobiles();
        if (this$remarkMobiles == null ? other$remarkMobiles != null : !this$remarkMobiles.equals(other$remarkMobiles)) {
            return false;
        }
        String this$operUserid = this.getOperUserid();
        String other$operUserid = other.getOperUserid();
        if (this$operUserid == null ? other$operUserid != null : !this$operUserid.equals(other$operUserid)) {
            return false;
        }
        Integer this$addWay = this.getAddWay();
        Integer other$addWay = other.getAddWay();
        if (this$addWay == null ? other$addWay != null : !((Object)this$addWay).equals(other$addWay)) {
            return false;
        }
        String this$linkState = this.getLinkState();
        String other$linkState = other.getLinkState();
        if (this$linkState == null ? other$linkState != null : !this$linkState.equals(other$linkState)) {
            return false;
        }
        Integer this$relStatus = this.getRelStatus();
        Integer other$relStatus = other.getRelStatus();
        if (this$relStatus == null ? other$relStatus != null : !((Object)this$relStatus).equals(other$relStatus)) {
            return false;
        }
        Date this$leaveTime = this.getLeaveTime();
        Date other$leaveTime = other.getLeaveTime();
        if (this$leaveTime == null ? other$leaveTime != null : !((Object)this$leaveTime).equals(other$leaveTime)) {
            return false;
        }
        Long this$scCorpId = this.getScCorpId();
        Long other$scCorpId = other.getScCorpId();
        if (this$scCorpId == null ? other$scCorpId != null : !((Object)this$scCorpId).equals(other$scCorpId)) {
            return false;
        }
        Date this$gmtCreate = this.getGmtCreate();
        Date other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Date this$gmtModified = this.getGmtModified();
        Date other$gmtModified = other.getGmtModified();
        return !(this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserCustomerRelDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $scUserId = this.getScUserId();
        result = result * 59 + ($scUserId == null ? 43 : ((Object)$scUserId).hashCode());
        Long $wechatCustomerId = this.getWechatCustomerId();
        result = result * 59 + ($wechatCustomerId == null ? 43 : ((Object)$wechatCustomerId).hashCode());
        String $customerUserId = this.getCustomerUserId();
        result = result * 59 + ($customerUserId == null ? 43 : $customerUserId.hashCode());
        String $customerRemark = this.getCustomerRemark();
        result = result * 59 + ($customerRemark == null ? 43 : $customerRemark.hashCode());
        String $customerDescription = this.getCustomerDescription();
        result = result * 59 + ($customerDescription == null ? 43 : $customerDescription.hashCode());
        String $remarkCorpName = this.getRemarkCorpName();
        result = result * 59 + ($remarkCorpName == null ? 43 : $remarkCorpName.hashCode());
        String $remarkMobiles = this.getRemarkMobiles();
        result = result * 59 + ($remarkMobiles == null ? 43 : $remarkMobiles.hashCode());
        String $operUserid = this.getOperUserid();
        result = result * 59 + ($operUserid == null ? 43 : $operUserid.hashCode());
        Integer $addWay = this.getAddWay();
        result = result * 59 + ($addWay == null ? 43 : ((Object)$addWay).hashCode());
        String $linkState = this.getLinkState();
        result = result * 59 + ($linkState == null ? 43 : $linkState.hashCode());
        Integer $relStatus = this.getRelStatus();
        result = result * 59 + ($relStatus == null ? 43 : ((Object)$relStatus).hashCode());
        Date $leaveTime = this.getLeaveTime();
        result = result * 59 + ($leaveTime == null ? 43 : ((Object)$leaveTime).hashCode());
        Long $scCorpId = this.getScCorpId();
        result = result * 59 + ($scCorpId == null ? 43 : ((Object)$scCorpId).hashCode());
        Date $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Date $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        return result;
    }

    public String toString() {
        return "UserCustomerRelDto(id=" + this.getId() + ", scUserId=" + this.getScUserId() + ", wechatCustomerId=" + this.getWechatCustomerId() + ", customerUserId=" + this.getCustomerUserId() + ", customerRemark=" + this.getCustomerRemark() + ", customerDescription=" + this.getCustomerDescription() + ", remarkCorpName=" + this.getRemarkCorpName() + ", remarkMobiles=" + this.getRemarkMobiles() + ", operUserid=" + this.getOperUserid() + ", addWay=" + this.getAddWay() + ", linkState=" + this.getLinkState() + ", relStatus=" + this.getRelStatus() + ", leaveTime=" + this.getLeaveTime() + ", scCorpId=" + this.getScCorpId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ")";
    }
}

