package cn.com.duiba.scrm.center.api.dto.corp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 企业应用关联表
* 2021-7-12 15:41:19
*/
@Data
public class ScCorpSuiteDto implements Serializable {

    /**
    * 企业信息id
    */
    private Long corpAccountId;

    /**
    * 删除标记 1、已删除
    */
    private Integer delFlag;

    /**
    * 主键id
    */
    private Long id;

    /**
    * 应用信息id
    */
    private Long suiteAccountId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 应用id
     */
    private Integer agentId;
    /**
     * 永久授权码
     */
    private String permanentCode;

    /**
     * 授权用户信息
     */
    private String authUserInfo;

    /**
     * 授权时间
     */
    private Date authTime;


    public ScCorpSuiteDto(Long corpAccountId, Long suiteAccountId,Integer agentId,String permanentCode,String authUserInfo,Date authTime){
        this.corpAccountId = corpAccountId;
        this.suiteAccountId = suiteAccountId;
        this.delFlag = 0;
        this.agentId = agentId;
        this.permanentCode = permanentCode;
        this.authTime = authTime;
        this.authUserInfo = authUserInfo;
    }
    public ScCorpSuiteDto(){

    }
}

