package cn.com.duiba.scrm.center.api.dto.customer;

import cn.com.duiba.scrm.center.api.enums.UserCustomerRelStatus;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.ExternalUserDetailResult;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 企业微信客户表
* 2021-7-23 15:35:19
*/
@Data
public class WechatCustomerDto implements Serializable {

    /**
    * 主键id,自增
    */
    private Long id;

    /**
    * 外部联系人的userid
    */
    private String externalUserid;

    /**
    * 外部联系人名称
    */
    private String customerName;

    /**
    * 外部联系人头像
    */
    private String customerAvatar;

    /**
    * 外部联系人的类型，1表示该外部联系人是微信用户，2表示该外部联系人是企业微信用户
    */
    private Integer customerType;

    /**
    * 外部联系人性别 0-未知 1-男性 2-女性
    */
    private Integer customerGender;

    /**
    * 外部联系人在微信开放平台的唯一身份标识,通过此字段企业可将外部联系人与公众号/小程序用户关联起来。
    */
    private String customerUnionid;

    /**
    * 外部联系人所在企业的简称，仅当联系人类型是企业微信用户时有此字段
    */
    private String corpName;

    /**
    * 外部联系人所在企业的主体名称，仅当联系人类型是企业微信用户时有此字段
    */
    private String corpFullName;

    /**
    * 外部联系人的职位，如果外部企业或用户选择隐藏职位，则不返回，仅当联系人类型是企业微信用户时有此字段
    */
    private String customerPosition;

    /**
    * 企业id
    */
    private Long scCorpId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;




    public static WechatCustomerDto convert(ExternalUserDetailResult.ExternalContact externalContact,Long scCorpId){
        WechatCustomerDto wechatCustomerDto = new WechatCustomerDto();
        wechatCustomerDto.setCorpFullName(externalContact.getCorpFullName());
        wechatCustomerDto.setCorpName(externalContact.getCorpName());
        wechatCustomerDto.setCustomerAvatar(externalContact.getAvatar());
        wechatCustomerDto.setCustomerGender(externalContact.getGender());
        wechatCustomerDto.setCustomerName(externalContact.getName());
        wechatCustomerDto.setCustomerPosition(externalContact.getPosition());
        wechatCustomerDto.setCustomerType(externalContact.getType());
        wechatCustomerDto.setCustomerUnionid(externalContact.getUnionid());
        wechatCustomerDto.setExternalUserid(externalContact.getExternalUserid());
        wechatCustomerDto.setScCorpId(scCorpId);
        return wechatCustomerDto;
    }




}

