package cn.com.duiba.scrm.center.api.dto.tag;

import cn.com.duiba.scrm.center.api.dto.base.BaseDto;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer.WeCropGroupTagParamBean;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * 企业微信标签
 * 2021-7-24 19:23:53
 */
@Data
public class TagDto implements BaseDto {

    private static final long serialVersionUID = -2016341040189169938L;
    /**
     * 主键id，自增
     */
    private Long id;

    /**
     * 标签组id:sc_tag_group.group_id
     */
    private String groupId;

    /**
     * 标签名
     */
    private String tagName;

    /**
     * 状态（1正常 0删除）
     */
    private Integer tagStatus;

    /**
     * 微信端返回的id
     */
    private String tagId;

    /**
     * 标签排序的次序值
     */
    private Integer tagOrder;

    /**
     * 企业id
     */
    private Long scCorpId;

    /**
     * 创建人ID:sc_user.id
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;


    public static TagDto convert(WeCropGroupTagParamBean.WeCorpTagParamBean weCropTagParam, String groupId) {
        TagDto tagDto = new TagDto();
        tagDto.setGroupId(groupId);
        tagDto.setTagId(weCropTagParam.getId());
        tagDto.setTagName(weCropTagParam.getName());
        tagDto.setTagOrder(weCropTagParam.getOrder());
        tagDto.setTagStatus(Objects.isNull(weCropTagParam.getDeleted()) ? null : weCropTagParam.getDeleted() ? 0 : 1);
        if (weCropTagParam.getCreateTime() != null) {
            tagDto.setGmtModified(new Date(weCropTagParam.getCreateTime()));
        }

        return tagDto;
    }


}

