package cn.com.duiba.scrm.center.api.param;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/7/27 20:45
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TagEditParam extends BaseOperateParam {
    private static final long serialVersionUID = -7160707655783560134L;

    /**
     * 标签或标签组的 id
     */
    private String id;

    /**
     * 新的标签或标签组名称，最长为 30 个字符
     */
    private String name;

    /**
     * 标签 / 标签组的次序值。order 值大的排序靠前。有效的值范围是 [0, 2^32)
     */
    private Integer order;
}
