package cn.com.duiba.scrm.center.api.dto.customer;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 操作日志记录
* 2021-8-6 14:20:30
*/
@Data
public class OperLogDto implements Serializable {

    /**
    * 日志主键
    */
    private Long id;

    /**
    * 类型
    */
    private String partTitle;

    /**
    * 操作行为
    */
    private String businessType;

    /**
    * 方法名称
    */
    private String methodName;

    /**
    * 请求方式
    */
    private String requestMethod;

    /**
    * 操作类别（0其它 1admin 2web）
    */
    private Integer operatorFromType;

    /**
    * 操作人员
    */
    private Long scUserId;

    /**
    * 请求URL
    */
    private String operUrl;

    /**
    * 主机地址
    */
    private String operIp;

    /**
    * 请求参数
    */
    private String operParam;

    /**
    * 返回参数
    */
    private String jsonResult;

    /**
    * 操作状态（0正常 1异常）
    */
    private Integer operStatus;

    /**
    * 错误消息
    */
    private String errorMsg;

    /**
    * 操作时间
    */
    private Date operTime;

    /**
    * 企业id
    */
    private Long corpId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


}

