package cn.com.duiba.scrm.center.api.dto.department;

import java.io.Serializable;
import java.util.Date;

/**
 * 企业微信组织架构相关
 * 2021-7-17 10:32:42
 */
public class DepartmentDto implements Serializable {
    private static final long serialVersionUID = 8882876657294047976L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 微信的部门ID
     */
    private Long deptId;

    /**
     * 部门祖籍列表
     */
    private String deptAncestors;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 微信的部门父id
     */
    private Long parentId;

    /**
     * 企业id
     */
    private Long scCorpId;

    /**
     * 状态： 0：关闭 1：开启
     */
    private Integer deptStatus;

    /**
     * 应用创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public DepartmentDto() {
    }

    public DepartmentDto(String deptName, String deptAncestors) {
        this.deptAncestors = deptAncestors;
        this.deptName = deptName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptAncestors() {
        return deptAncestors;
    }

    public void setDeptAncestors(String deptAncestors) {
        this.deptAncestors = deptAncestors;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getScCorpId() {
        return scCorpId;
    }

    public void setScCorpId(Long scCorpId) {
        this.scCorpId = scCorpId;
    }

    public Integer getDeptStatus() {
        return deptStatus;
    }

    public void setDeptStatus(Integer deptStatus) {
        this.deptStatus = deptStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

