package cn.com.duiba.scrm.center.api.exception;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ErrorCode.java
 * @Description TODO
 * @createTime 2021年07月14日 14:55:00
 */
public enum ErrorCode {
    /**
     * 999开头为系统级异常
     */
    ERROR("999999", "未知异常"),
    /**
     * 9991开头为参数异常
     */
    NOT_NULL("999100", "参数[param]不能为空"),


    /*-------------------------001***用户授权登陆模块异常--------------------------*/
    USER_NOT_LOGIN("001001", "用户未登陆"),
    USER_WCHAT_PARAM("001002", "微信获取用户信息异常"),
    USER_WCHAT_CORP_STATUS_ERROR("001003", "公司授权状态异常"),
    SELF_SUITE_NOT_EXIST("001004", "自建应用不存在"),
    THIRD_SUITE_NOT_EXIST("001005", "第三方应用未授权"),


    /*-------------------------002***成员模块异常--------------------------*/
    USER_SYNC_DOING("002001", "更新中，稍后查看"),
    USER_IS_NULL("002002", "用户不存在"),
    USERS_IS_NOT_EMPTY("002003", "用户不能为空"),
    USERS_IS_NOT_AUTH("002004", "用户未授权"),

    /*--------------------------003功能权限异常--------------------------*/
    NO_PERMISSION("003001", "权限不足"),
    ROLE_IS_NULL("003002", "角色不存在"),

    /*---------------------------004调用微信接口异常----------------------------*/
    CREATE_EMPLE_CODE_ERROR("004001", "创建客户联系码异常"),
    UPDATE_EMPLE_CODE_ERROR("004002", "更新客户联系码异常"),

    /*--------------------------005活码模块异常-----------------------------*/
    CODE_NOT_EXIST("005001", "活码不存在"),

    /*--------------------------006 群发异常-----------------------------*/
    SEND_TIME_MIN_LIMIT("006001", "定时发送时间必须在当前时间5分钟后"),
    SEND_TIME_MAX_LIMIT("006002", "定时发送时间必须在1个月内"),


    /*---------------------------007 企业信息异常---------------------------------*/
    CORP_IS_NULL("007001", "获取不到企业信息"),

    /*---------------------------008 微信群相关---------------------------------*/
    CHAT_GROUP_IS_NULL("008001", "微信群不存在"),
    ;

    private String code;

    private String msg;

    ErrorCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
