package cn.com.duiba.scrm.center.api.param.customer;

import cn.com.duiba.scrm.center.api.param.BaseOperateParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2021/7/26 12:53
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerNoUnionQueryParam extends BaseOperateParam {

    /**
     * 性别 0 全部性别，1 仅男性粉丝，2 仅女性粉丝，3 未知性别
     */
    private Integer genderType;

    /**
     * 所在群聊
     */
    private List<String> groupIds;

    /**
     * 0 表示全部群组, 1表示已入群，2表示未入群
     */
    private Integer allGroup;

    /**
     * 添加时间-开始日期
     */
    private Date start;

    /**
     * 添加时间-结束日期
     */
    private Date end;

    /**
     * 企微客户标签
     */
    private List<Long> tagIds;

    /**
     * 所属员工
     */
    private List<Long> userIds;
}
