package cn.com.duiba.scrm.center.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.customer.OperLogDto;
import cn.com.duiba.scrm.center.api.param.customer.RemoteOperLogQueryParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

/**
* 操作日志记录 RemoteService
* @author xiaotian
* 2021-8-6 14:20:30
*/
@AdvancedFeignClient
public interface RemoteOperLogService {
    /**
    * 新增记录
    */
	Boolean save(OperLogDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(OperLogDto dto);
    /**
    * 根据id获取
    */
    OperLogDto getById(Long id);

    ScrmResult<ScrmPageResult<OperLogDto>> query(RemoteOperLogQueryParam param);


}
