package cn.com.duiba.scrm.center.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.customer.CodeCustomerStatisticsDto;
import cn.com.duiba.scrm.center.api.dto.customer.CountLinkStateDto;
import cn.com.duiba.scrm.center.api.dto.customer.UserCustomerRelDto;
import cn.com.duiba.scrm.center.api.dto.customer.UserCustomerStatisticsDto;
import cn.com.duiba.scrm.center.api.param.customer.CodeCustomerQueryParam;
import cn.com.duiba.scrm.center.api.param.customer.CountLinkStateParam;
import cn.com.duiba.scrm.center.api.param.customer.CustomerNoUnionQueryParam;
import cn.com.duiba.scrm.center.api.param.customer.CustomerQueryParam;
import cn.com.duiba.scrm.center.api.param.customer.HomeCustomerQueryParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;
import java.util.Map;

/**
 * 具有外部联系人功能企业员工也客户的关系表 RemoteService
 *
 * @author xiaotian
 * 2021-7-23 15:36:33
 */
@AdvancedFeignClient
public interface RemoteUserCustomerRelService {
    /**
     * 新增记录
     */
    Boolean save(UserCustomerRelDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(UserCustomerRelDto dto);

    /**
     * 根据id获取
     */
    UserCustomerRelDto getById(Long id);

    ScrmResult<List<UserCustomerRelDto>> getByIds(List<Long> ids);

    /**
     * 筛选客户列表
     *
     * @param customerQueryParam
     * @return
     */
    ScrmPageResult<UserCustomerRelDto> pageQuery(CustomerQueryParam customerQueryParam);


    /**
     * 获取去重数量
     *
     * @param customerQueryParam
     * @return
     */
    Long distinctQuery(CustomerQueryParam customerQueryParam);


    /**
     * 根据客户id获取成员列表
     *
     * @param scCorpId
     * @param customerId
     * @return
     */
    List<UserCustomerRelDto> getListByCorpIdAndCustomerId(Long scCorpId, Long customerId);


    /**
     * 根据企业Id，成员Id，客户Id，获取唯一一条记录
     *
     * @param scCorpId
     * @param userId
     * @param customerId
     * @return
     */
    UserCustomerRelDto getByCorpIdAndUserIdAndCustomerId(Long scCorpId, Long userId, Long customerId);

    /**
     * 统计符合条件的数量
     *
     * @param dto
     * @return
     */
    ScrmResult<Integer> countNum(UserCustomerRelDto dto);

    /**
     * 根据员工Id获取客户数量
     *
     * @param userIds
     * @return
     */
    ScrmResult<Map<Long, Long>> getCustomerIdCountByUSerIds(Long scCorpId, List<Long> userIds);

    /**
     * 统计成员客户数
     *
     * @param userId
     * @return
     */
    UserCustomerStatisticsDto statisticsUser(Long scCorpId, Long userId);

    /**
     * 筛选客户列表，筛选条件为且
     */
    ScrmResult<ScrmPageResult<UserCustomerRelDto>> pageQueryAuth(CustomerQueryParam customerQueryParam);

    /**
     * 筛选客户列表, 筛选条件为或
     */
    ScrmResult<ScrmPageResult<UserCustomerRelDto>> pageQueryNoUnionAuth(CustomerNoUnionQueryParam customerNoUnionQueryParam);

    /*
     * 统计公司客户数
     *
     * @param homeCustomerQueryParam
     * @return
     */
    UserCustomerStatisticsDto homeStatistics(HomeCustomerQueryParam homeCustomerQueryParam);


    /**
     * 概况根据自己的筛选条件统计数据
     *
     * @param homeCustomerQueryParam
     * @return
     */
    Long homeCustomerQueryCount(HomeCustomerQueryParam homeCustomerQueryParam);


    /**
     * 活码客户统计
     *
     * @param codeCustomerQueryParam
     * @return
     */
    ScrmPageResult<CodeCustomerStatisticsDto> codeStatistics(CodeCustomerQueryParam codeCustomerQueryParam);


    /**
     * 活码客户统计（获取客户的成员列表）
     *
     * @param codeCustomerQueryParam
     * @return
     */
    ScrmPageResult<Long> codeStatisticsForUser(CodeCustomerQueryParam codeCustomerQueryParam);


    /**
     * 活码员工客户数查询（count）
     *
     * @param codeCustomerQueryParam
     * @return
     */
    Long queryCodeCustomerCount(CodeCustomerQueryParam codeCustomerQueryParam);

    /**
     * 统计渠道来源
     *
     * @param param
     * @return
     */
    ScrmResult<List<CountLinkStateDto>> countLinkStateNum(CountLinkStateParam param);

    /**
     * 单个活码的统计数据
     * @param codeCustomerQueryParam
     * @return
     */
    ScrmResult<Integer> countQueryTypeByCodeId(CodeCustomerQueryParam codeCustomerQueryParam);

    ScrmResult<List<UserCustomerRelDto>> getByScUserId(Long scCorpId, List<Long> scUserIds);
}
