package cn.com.duiba.scrm.center.api.remoteservice.groupmsg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.groupmsg.GroupMsgTaskDto;
import cn.com.duiba.scrm.center.api.param.groupmsg.GroupMsgTaskQueryParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.Map;

/**
* 成员发送任务表 RemoteService
* @author xiaotian
* 2021-7-30 13:39:37
*/
@AdvancedFeignClient
public interface RemoteGroupMsgTaskService {
    /**
    * 新增记录
    */
	Boolean save(GroupMsgTaskDto dto);

    /**
    * 根据id删除
    */
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    Boolean updateById(GroupMsgTaskDto dto);
    /**
    * 根据id获取
    */
    GroupMsgTaskDto getById(Long id);

    /**
     * 根据查询条件统计数据
     * @param groupMsgTaskQueryParam ScrmResult<Long>
     * @return ScrmResult<Long>
     */
    ScrmResult<Map<Long, Long>> countByParam(GroupMsgTaskQueryParam groupMsgTaskQueryParam);
}
