package cn.com.duiba.scrm.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.tag.TagBizDto;
import cn.com.duiba.scrm.center.api.param.tag.GetByBizParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 标签与其他业务关联表 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 10:33:12
 */
@AdvancedFeignClient
public interface RemoteTagBizService {
    /**
     * 新增记录
     */
    Boolean save(TagBizDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(TagBizDto dto);

    /**
     * 根据id获取
     */
    TagBizDto getById(Long id);


    /**
     * 获取关联标签内容
     *
     * @param dto
     * @return
     */
    ScrmResult<List<TagBizDto>> getByDto(TagBizDto dto);

    /**
     * 通过业务列表获取标签
     *
     * @param param
     * @return
     */
    ScrmResult<List<TagBizDto>> getByBizList(GetByBizParam param);


}
