/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.center.api.dto.chatgroup;

import cn.com.duiba.scrm.center.api.dto.base.BaseDto;
import cn.com.duiba.scrm.center.api.enums.ChatAdminEnum;
import cn.com.duiba.scrm.center.api.enums.ChatMemerStatusEnum;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.CustomerGroupMemberResult;
import java.util.Date;
import java.util.Objects;

public class ChatGroupMemberDto
implements BaseDto {
    private static final long serialVersionUID = -1865925344882773466L;
    private Long id;
    private String userId;
    private String chatId;
    private String unionId;
    private Date joinTime;
    private Date leaveTime;
    private Integer joinScene;
    private Integer chatAdmin;
    private Integer memberStatus;
    private Integer memberType;
    private String memberName;
    private String invitorUserid;
    private String groupNickname;
    private Long scCorpId;
    private Date gmtCreate;
    private Date gmtModified;

    public static ChatGroupMemberDto convert(CustomerGroupMemberResult customerGroupMemberResult) {
        ChatGroupMemberDto chatGroupMemberDto = new ChatGroupMemberDto();
        chatGroupMemberDto.setGroupNickname(customerGroupMemberResult.getGroupNickname());
        if (Objects.nonNull(customerGroupMemberResult.getInvitor())) {
            chatGroupMemberDto.setInvitorUserid(customerGroupMemberResult.getInvitor().getUserid());
        }
        chatGroupMemberDto.setJoinScene(customerGroupMemberResult.getJoinScene());
        chatGroupMemberDto.setJoinTime(new Date(customerGroupMemberResult.getJoinTime() * 1000L));
        chatGroupMemberDto.setMemberName(customerGroupMemberResult.getName());
        chatGroupMemberDto.setMemberType(customerGroupMemberResult.getType());
        chatGroupMemberDto.setUnionId(customerGroupMemberResult.getUnionid());
        chatGroupMemberDto.setUserId(customerGroupMemberResult.getUserid());
        chatGroupMemberDto.setChatAdmin(ChatAdminEnum.NOMAL.getCode());
        chatGroupMemberDto.setMemberStatus(ChatMemerStatusEnum.IN.getCode());
        return chatGroupMemberDto;
    }

    public Long getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getChatId() {
        return this.chatId;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public Date getJoinTime() {
        return this.joinTime;
    }

    public Date getLeaveTime() {
        return this.leaveTime;
    }

    public Integer getJoinScene() {
        return this.joinScene;
    }

    public Integer getChatAdmin() {
        return this.chatAdmin;
    }

    public Integer getMemberStatus() {
        return this.memberStatus;
    }

    public Integer getMemberType() {
        return this.memberType;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getInvitorUserid() {
        return this.invitorUserid;
    }

    public String getGroupNickname() {
        return this.groupNickname;
    }

    public Long getScCorpId() {
        return this.scCorpId;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public void setJoinTime(Date joinTime) {
        this.joinTime = joinTime;
    }

    public void setLeaveTime(Date leaveTime) {
        this.leaveTime = leaveTime;
    }

    public void setJoinScene(Integer joinScene) {
        this.joinScene = joinScene;
    }

    public void setChatAdmin(Integer chatAdmin) {
        this.chatAdmin = chatAdmin;
    }

    public void setMemberStatus(Integer memberStatus) {
        this.memberStatus = memberStatus;
    }

    public void setMemberType(Integer memberType) {
        this.memberType = memberType;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public void setInvitorUserid(String invitorUserid) {
        this.invitorUserid = invitorUserid;
    }

    public void setGroupNickname(String groupNickname) {
        this.groupNickname = groupNickname;
    }

    public void setScCorpId(Long scCorpId) {
        this.scCorpId = scCorpId;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatGroupMemberDto)) {
            return false;
        }
        ChatGroupMemberDto other = (ChatGroupMemberDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$unionId = this.getUnionId();
        String other$unionId = other.getUnionId();
        if (this$unionId == null ? other$unionId != null : !this$unionId.equals(other$unionId)) {
            return false;
        }
        Date this$joinTime = this.getJoinTime();
        Date other$joinTime = other.getJoinTime();
        if (this$joinTime == null ? other$joinTime != null : !((Object)this$joinTime).equals(other$joinTime)) {
            return false;
        }
        Date this$leaveTime = this.getLeaveTime();
        Date other$leaveTime = other.getLeaveTime();
        if (this$leaveTime == null ? other$leaveTime != null : !((Object)this$leaveTime).equals(other$leaveTime)) {
            return false;
        }
        Integer this$joinScene = this.getJoinScene();
        Integer other$joinScene = other.getJoinScene();
        if (this$joinScene == null ? other$joinScene != null : !((Object)this$joinScene).equals(other$joinScene)) {
            return false;
        }
        Integer this$chatAdmin = this.getChatAdmin();
        Integer other$chatAdmin = other.getChatAdmin();
        if (this$chatAdmin == null ? other$chatAdmin != null : !((Object)this$chatAdmin).equals(other$chatAdmin)) {
            return false;
        }
        Integer this$memberStatus = this.getMemberStatus();
        Integer other$memberStatus = other.getMemberStatus();
        if (this$memberStatus == null ? other$memberStatus != null : !((Object)this$memberStatus).equals(other$memberStatus)) {
            return false;
        }
        Integer this$memberType = this.getMemberType();
        Integer other$memberType = other.getMemberType();
        if (this$memberType == null ? other$memberType != null : !((Object)this$memberType).equals(other$memberType)) {
            return false;
        }
        String this$memberName = this.getMemberName();
        String other$memberName = other.getMemberName();
        if (this$memberName == null ? other$memberName != null : !this$memberName.equals(other$memberName)) {
            return false;
        }
        String this$invitorUserid = this.getInvitorUserid();
        String other$invitorUserid = other.getInvitorUserid();
        if (this$invitorUserid == null ? other$invitorUserid != null : !this$invitorUserid.equals(other$invitorUserid)) {
            return false;
        }
        String this$groupNickname = this.getGroupNickname();
        String other$groupNickname = other.getGroupNickname();
        if (this$groupNickname == null ? other$groupNickname != null : !this$groupNickname.equals(other$groupNickname)) {
            return false;
        }
        Long this$scCorpId = this.getScCorpId();
        Long other$scCorpId = other.getScCorpId();
        if (this$scCorpId == null ? other$scCorpId != null : !((Object)this$scCorpId).equals(other$scCorpId)) {
            return false;
        }
        Date this$gmtCreate = this.getGmtCreate();
        Date other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Date this$gmtModified = this.getGmtModified();
        Date other$gmtModified = other.getGmtModified();
        return !(this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatGroupMemberDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $unionId = this.getUnionId();
        result = result * 59 + ($unionId == null ? 43 : $unionId.hashCode());
        Date $joinTime = this.getJoinTime();
        result = result * 59 + ($joinTime == null ? 43 : ((Object)$joinTime).hashCode());
        Date $leaveTime = this.getLeaveTime();
        result = result * 59 + ($leaveTime == null ? 43 : ((Object)$leaveTime).hashCode());
        Integer $joinScene = this.getJoinScene();
        result = result * 59 + ($joinScene == null ? 43 : ((Object)$joinScene).hashCode());
        Integer $chatAdmin = this.getChatAdmin();
        result = result * 59 + ($chatAdmin == null ? 43 : ((Object)$chatAdmin).hashCode());
        Integer $memberStatus = this.getMemberStatus();
        result = result * 59 + ($memberStatus == null ? 43 : ((Object)$memberStatus).hashCode());
        Integer $memberType = this.getMemberType();
        result = result * 59 + ($memberType == null ? 43 : ((Object)$memberType).hashCode());
        String $memberName = this.getMemberName();
        result = result * 59 + ($memberName == null ? 43 : $memberName.hashCode());
        String $invitorUserid = this.getInvitorUserid();
        result = result * 59 + ($invitorUserid == null ? 43 : $invitorUserid.hashCode());
        String $groupNickname = this.getGroupNickname();
        result = result * 59 + ($groupNickname == null ? 43 : $groupNickname.hashCode());
        Long $scCorpId = this.getScCorpId();
        result = result * 59 + ($scCorpId == null ? 43 : ((Object)$scCorpId).hashCode());
        Date $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Date $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        return result;
    }

    public String toString() {
        return "ChatGroupMemberDto(id=" + this.getId() + ", userId=" + this.getUserId() + ", chatId=" + this.getChatId() + ", unionId=" + this.getUnionId() + ", joinTime=" + this.getJoinTime() + ", leaveTime=" + this.getLeaveTime() + ", joinScene=" + this.getJoinScene() + ", chatAdmin=" + this.getChatAdmin() + ", memberStatus=" + this.getMemberStatus() + ", memberType=" + this.getMemberType() + ", memberName=" + this.getMemberName() + ", invitorUserid=" + this.getInvitorUserid() + ", groupNickname=" + this.getGroupNickname() + ", scCorpId=" + this.getScCorpId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ")";
    }
}

