/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.center.api.dto.customer;

import cn.com.duiba.scrm.center.api.dto.base.BaseDto;
import cn.com.duiba.scrm.common.enums.wechat.DuibaTagEnum;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.ExternalUserDetailResult;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class UserCustomerRelDto
implements BaseDto {
    private static final long serialVersionUID = -8448349222542068065L;
    private Long id;
    private Long scUserId;
    private Long wechatCustomerId;
    private String customerUserId;
    private String customerRemark;
    private String customerDescription;
    private String remarkCorpName;
    private String remarkMobiles;
    private String operUserid;
    private Integer addWay;
    private String linkState;
    private Integer relStatus;
    private Date leaveTime;
    private Date customerLeaveTime;
    private Long scCorpId;
    private Date gmtCreate;
    private Date gmtModified;

    public static UserCustomerRelDto convert(ExternalUserDetailResult.FollowUser followUser) {
        UserCustomerRelDto userCustomerRelDto = new UserCustomerRelDto();
        userCustomerRelDto.setAddWay(followUser.getAddWay());
        userCustomerRelDto.setCustomerDescription(followUser.getDescription());
        userCustomerRelDto.setCustomerRemark(followUser.getRemark());
        userCustomerRelDto.setRemarkMobiles(JSON.toJSONString((Object)followUser.getRemarkMobiles()));
        userCustomerRelDto.setOperUserid(followUser.getOperUserid());
        userCustomerRelDto.setRemarkCorpName(followUser.getRemarkCorpName());
        String state = followUser.getState();
        if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith(DuibaTagEnum.DUIBA.getTag())) {
            userCustomerRelDto.setLinkState(state);
        } else {
            userCustomerRelDto.setLinkState("other");
        }
        userCustomerRelDto.setGmtCreate(new Date(followUser.getCreatetime() * 1000L));
        return userCustomerRelDto;
    }

    public static UserCustomerRelDto convert(ExternalUserDetailResult.FollowInfo followInfo) {
        UserCustomerRelDto userCustomerRelDto = new UserCustomerRelDto();
        userCustomerRelDto.setAddWay(followInfo.getAdd_way());
        userCustomerRelDto.setCustomerDescription(followInfo.getDescription());
        userCustomerRelDto.setCustomerRemark(followInfo.getRemark());
        userCustomerRelDto.setRemarkMobiles(JSON.toJSONString((Object)followInfo.getRemark_mobiles()));
        userCustomerRelDto.setOperUserid(followInfo.getOper_userid());
        userCustomerRelDto.setRemarkCorpName(followInfo.getRemark_company());
        String state = followInfo.getState();
        if (StringUtils.isNotBlank((CharSequence)state) && state.startsWith(DuibaTagEnum.DUIBA.getTag())) {
            userCustomerRelDto.setLinkState(state);
        } else {
            userCustomerRelDto.setLinkState("other");
        }
        userCustomerRelDto.setGmtCreate(new Date(followInfo.getCreatetime() * 1000L));
        return userCustomerRelDto;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getScUserId() {
        return this.scUserId;
    }

    public void setScUserId(Long scUserId) {
        this.scUserId = scUserId;
    }

    public Long getWechatCustomerId() {
        return this.wechatCustomerId;
    }

    public void setWechatCustomerId(Long wechatCustomerId) {
        this.wechatCustomerId = wechatCustomerId;
    }

    public String getCustomerUserId() {
        return this.customerUserId;
    }

    public void setCustomerUserId(String customerUserId) {
        this.customerUserId = customerUserId;
    }

    public String getCustomerRemark() {
        return this.customerRemark;
    }

    public void setCustomerRemark(String customerRemark) {
        this.customerRemark = customerRemark;
    }

    public String getCustomerDescription() {
        return this.customerDescription;
    }

    public void setCustomerDescription(String customerDescription) {
        this.customerDescription = customerDescription;
    }

    public String getRemarkCorpName() {
        return this.remarkCorpName;
    }

    public void setRemarkCorpName(String remarkCorpName) {
        this.remarkCorpName = remarkCorpName;
    }

    public String getRemarkMobiles() {
        return this.remarkMobiles;
    }

    public void setRemarkMobiles(String remarkMobiles) {
        this.remarkMobiles = remarkMobiles;
    }

    public String getOperUserid() {
        return this.operUserid;
    }

    public void setOperUserid(String operUserid) {
        this.operUserid = operUserid;
    }

    public Integer getAddWay() {
        return this.addWay;
    }

    public void setAddWay(Integer addWay) {
        this.addWay = addWay;
    }

    public String getLinkState() {
        return this.linkState;
    }

    public void setLinkState(String linkState) {
        this.linkState = linkState;
    }

    public Integer getRelStatus() {
        return this.relStatus;
    }

    public void setRelStatus(Integer relStatus) {
        this.relStatus = relStatus;
    }

    public Date getLeaveTime() {
        return this.leaveTime;
    }

    public void setLeaveTime(Date leaveTime) {
        this.leaveTime = leaveTime;
    }

    public Date getCustomerLeaveTime() {
        return this.customerLeaveTime;
    }

    public void setCustomerLeaveTime(Date customerLeaveTime) {
        this.customerLeaveTime = customerLeaveTime;
    }

    public Long getScCorpId() {
        return this.scCorpId;
    }

    public void setScCorpId(Long scCorpId) {
        this.scCorpId = scCorpId;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

