package cn.com.duiba.scrm.center.api.dto.groupmsg;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 客户群发
* 2021-7-30 13:39:35
*/
@Data
public class GroupMsgDto implements Serializable {

    private static final long serialVersionUID = 9206891328618966045L;
    /**
    * 查询条件
    */
    private String bizParam;

    /**
    * 群发任务类型，默认为single, single 表示发送给客户，group 表示发送给客户群
    */
    private String chatType;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;

    /**
    * 群发名称
    */
    private String groupMsgName;

    /**
    * 状态，1 发送成功，2 待发送，3 创建失败，4 已取消（初始状态为待发送）5 发送中
    */
    private Integer groupMsgStatus;

    /**
    * 群发类型，1 立即发送，2 定时发送
    */
    private Integer groupMsgType;

    /**
    * 主键id，自增
    */
    private Long id;

    /**
    * 修改人ID:sc_user.id
    */
    private Long modifiedBy;

    /**
    * 企业id
    */
    private Long scCorpId;

    /**
    * 发送时间
    */
    private Date sendTime;

    /**
     * 错误原因
     */
    private String errorMsg;
}

