package cn.com.duiba.scrm.center.api.enums;

import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0.0
 * @ClassName ChatAdminEnum.java
 * @Description 动态类型枚举
 * @createTime 2021年07月15日 11:07:00
 */
public enum DynamicTypeEnum {

    /**
     * Ta 添加了员工「员工昵称」为好友
     */
    ADD_FRIEND_CUSTOMER(1, "客户添加员工"),
    /**
     * 员工「员工昵称」添加了 Ta
     */
    ADD_FRIEND_USER(2, "员工添加客户"),
    /**
     * Ta 删除了员工「员工昵称」
     */
    DEL_FRIEND_CUSTOMER(3, "客户删除员工"),
    /**
     * 员工「员工昵称」删除了 Ta
     */
    DEL_FRIEND_USER(4, "员工删除客户"),

    /**
     * 员工「员工昵称」添加了备注「备注内容」
     */
    EDIT_ADD_REMARK(5, "员工添加客户备注"),

    /**
     * 员工「员工昵称」将备注「原备注内容」修改为「新备注内容」
     */
    EDIT_MODIFY_REMARK(6, "员工修改客户备注"),

    /**
     * 员工「员工昵称」添加了电话「电话号码」
     */
    EDIT_ADD_MOBILE(7, "员工添加客户手机号"),

    /**
     * 员工「员工昵称」将电话「原电话号码」修改为「新电话号码」
     */
    EDIT_MODIFY_MOBILE(8, "员工修改客户手机号"),

    /**
     * 员工「员工昵称」删除了电话「原电话号码」
     */
    EDIT_DEL_MOBILE(9, "员工删除客户手机号"),

    /**
     * 员工「员工昵称」添加了描述「描述内容」
     */
    EDIT_ADD_DESC(10, "员工添加客户描述"),

    /**
     * 员工「员工昵称」将描述「原描述内容」修改为「新描述内容」
     */
    EDIT_MODIFY_DESC(11, "员工修改客户描述"),

    /**
     * 员工「员工昵称」删除了描述「原描述内容」
     */
    EDIT_DEL_DESC(12, "员工删除客户描述"),

    /**
     * 员工「员工昵称」给 ta 添加了标签「标签名称」
     */
    TAG_ADD(13, "员工添加客户标签"),

    /**
     * 员工「员工昵称」取消了 ta 的标签「标签名称」
     */
    TAG_DEL(14, "员工删除客户标签"),

    /**
     * Ta 加入了群聊「群聊名称」
     */
    CHAT_IN(15, "加入群聊"),

    /**
     * Ta 退出了群聊「群聊名称」
     */
    CHAT_OUT(16, "退出群聊");

    private Integer code;

    private String msg;

    DynamicTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }


    @Data
    @Builder
    public static class DelCostomerDynamic {
        String userName;
    }

    @Data
    @Builder
    public static class EditAddRemarkDynamic {

        String userName;

        String desc;
    }


    @Data
    @Builder
    public static class EditModifyRemarkDynamic {

        String userName;

        String oldDesc;

        String newDesc;
    }

    @Data
    @Builder
    public static class EditAddMobileDynamic {

        String userName;

        String mobile;
    }

    @Data
    @Builder
    public static class EditModifyMobileDynamic {

        String userName;

        String oldMobile;

        String newMobile;
    }

    @Data
    @Builder
    public static class EditDelMobileDynamic {

        String userName;

        String mobile;
    }

    @Data
    @Builder
    public static class EditAddDescDynamic {

        String userName;

        String desc;
    }

    @Data
    @Builder
    public static class EditModifyDescDynamic {

        String userName;

        String oldDesc;

        String newDesc;
    }

    @Data
    @Builder
    public static class EditDelDescDynamic {

        String userName;

        String desc;
    }


    @Data
    @Builder
    public static class ChatInDynamic {
        String chatName;

        String memberName;
    }

    @Data
    @Builder
    public static class ChatOutDynamic {
        String chatName;

        String memberName;
    }


    @Data
    @Builder
    public static class TagAddDynamic {
        String userName;

        List<String> tags;
    }

    @Data
    @Builder
    public static class TagDelDynamic {
        String userName;

        List<String> tags;
    }


    @Data
    @Builder
    public static class AddcustomerDynamic {
        String userName;
    }


}
