package cn.com.duiba.scrm.center.api.param.material;

import cn.com.duiba.scrm.center.api.param.BaseOperateParam;

import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description: 素材批量保存参数
 * @date 2021/7/31 10:20
 */
public class MaterialSaveParam extends BaseOperateParam {

    private static final long serialVersionUID = -6445177165993679816L;

    /**
     * 关联业务id
     */
    private Long bizId;

    /**
     * 业务类型1、个人活码，2、欢迎语, 3、群发
     */
    private Integer bizType;

    /**
     * 创建者
     */
    private Long createBy;

    /**
     * 删除标记 0:正常 1:删除
     */
    private Integer delFlag;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 描述
     */
    private String materialDesc;

    /**
     * 名称
     */
    private String materialName;

    /**
     * 图片
     */
    private String materialPic;

    /**
     * 文本
     */
    private String materialText;

    /**
     * 类型1文字，2图片，3链接
     */
    private Integer materialType;

    public Long getBizId() {
        return bizId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Integer getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialPic() {
        return materialPic;
    }

    public void setMaterialPic(String materialPic) {
        this.materialPic = materialPic;
    }

    public String getMaterialText() {
        return materialText;
    }

    public void setMaterialText(String materialText) {
        this.materialText = materialText;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }
}
