package cn.com.duiba.scrm.center.api.param.wechatUser;

import cn.com.duiba.scrm.center.api.param.BaseOperateParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能描述：企业成员筛选参数对象
 *
 * @Auther: xiaotian
 * @Date: 2021/7/18 11:58
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WechatUserPageQuery extends BaseOperateParam {

    private static final long serialVersionUID = 5419558321639569511L;

    private List<Long> userIds = new ArrayList<>();

    /**
     * 员工昵称
     */
    private String name;

    /**
     * 角色ID
     */
    private Long roleId;

    /**
     * 部门Id
     *
     * @deprecated 放在deptIds里
     */
    @Deprecated
    private Long deptId;

    /**
     * 部门Ids
     */
    private List<Long> deptIds = new ArrayList<>();

    /**
     * 是否展示子部门的员工
     */
    private Boolean useChild = false;


    /**
     * 是否要搜索群主
     */
    private Integer groupOwner = 0;

    public List<Long> getUserIds() {
        return userIds;
    }

    public void setUserIds(List<Long> userIds) {
        this.userIds = userIds;
    }
}
