package cn.com.duiba.scrm.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.tag.TagDto;
import cn.com.duiba.scrm.center.api.dto.tag.TagGroupDetailDto;
import cn.com.duiba.scrm.center.api.param.TagDeleteParam;
import cn.com.duiba.scrm.center.api.param.TagEditParam;
import cn.com.duiba.scrm.center.api.param.TagQueryParam;
import cn.com.duiba.scrm.center.api.param.TagSaveParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 企业微信标签 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 19:23:53
 */
@AdvancedFeignClient
public interface RemoteTagService {
    /**
     * 新增记录
     */
    @Deprecated
    Boolean save(TagDto dto);

    /**
     * 根据id删除
     */
    @Deprecated
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    @Deprecated
    Boolean updateById(TagDto dto);

    /**
     * 根据id获取
     */
    @Deprecated
    TagDto getById(Long id);

    @Deprecated
    List<TagDto> getByIds(List<Long> ids);

    @Deprecated
    List<TagDto> getByTagIds(Long scCorpId, List<String> tagIds);


    ScrmResult<ScrmPageResult<TagDto>> queryPage(TagQueryParam queryParam);


    /**
     * 以下三个接口均为先调用微信接口，再进行标签同步
     */
    ScrmResult<TagGroupDetailDto> addTag(TagSaveParam param);

    ScrmResult<Boolean> editTag(TagEditParam param);

    ScrmResult<Boolean> delTag(TagDeleteParam param);
}
