/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.center.api.enums;

import cn.com.duiba.scrm.center.api.enums.RoleLevelEnum;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum PermsFlagEnum {
    OVERVIEW(0, "\u6982\u51b5", "overview", true, true, true, true),
    OVERVIEW_1(1, "\u6982\u51b5", "overview/overview", true, true, true, true),
    OPERATION(0, "\u5f15\u6d41\u83b7\u5ba2", "operation", true, true, true, false),
    LIVE_QRCODE(1, "\u6e20\u9053\u6d3b\u7801", "operation/live-qrcode", true, true, true, false),
    PROMOTE(0, "\u4fc3\u6d3b\u8f6c\u5316", "conversion", true, true, true, true),
    SALUTATION(1, "\u6b22\u8fce\u8bed", "conversion/welcome", true, true, true, false),
    Masssende(1, "\u7fa4\u53d1\u6d88\u606f", "conversion/message", true, true, true, false),
    WORDSLIBRARY(1, "\u8bdd\u672f\u5e93", "conversion/knowledge", true, true, true, false),
    MEDIALIBRARY(1, "\u7d20\u6750\u5e93", "conversion/material", true, true, true, false),
    PORTRAIT(1, "\u5ba2\u6237\u753b\u50cf", "conversion/customer-portrait", true, true, true, true),
    QUICKREPLY(1, "\u5feb\u6377\u56de\u590d", "conversion/fast-reply", true, true, true, true),
    WORK_TABE(1, "\u5de5\u4f5c\u53f0", "conversion/workbench", true, true, true, true),
    GROUP_SOP(1, "\u7fa4 sop", "conversion/group-sop", true, true, true, true),
    RADAR(1, "\u4e92\u52a8\u96f7\u8fbe", "conversion/radar", true, true, true, true),
    GROUP_TAG(1, "\u5ba2\u6237\u7fa4\u6807\u7b7e", "customer/group-tag", true, true, false, false),
    CUSTOMER(0, "\u5ba2\u6237\u7ba1\u7406", "customer", true, true, true, true),
    USER_MANAGER(1, "\u5ba2\u6237\u7ba1\u7406", "customer/management", true, true, true, true),
    GROUP_MANAGER(1, "\u5ba2\u6237\u7fa4\u7ba1\u7406", "customer/group", true, true, true, true),
    TAG(1, "\u5ba2\u6237\u6807\u7b7e", "customer/tag", true, true, false, false),
    CHURN(1, "\u6d41\u5931\u63d0\u9192", "customer/lost-customer", true, true, true, true),
    MANAGEMENT(0, "\u4f01\u4e1a\u7ba1\u7406", "management", true, true, true, true),
    STAFFE(1, "\u5458\u5de5\u7ba1\u7406", "management/staff", true, true, true, true),
    PRIVILEGE(1, "\u6743\u9650\u7ba1\u7406", "management/privilege", true, true, true, false),
    DELETE(1, "\u5220\u5ba2\u6237\u63d0\u9192", "management/delete-customer", true, true, true, true);

    private final Integer level;
    private final String name;
    private final String permsFlag;
    private final Boolean rootManager;
    private final Boolean manager;
    private final Boolean departmentManager;
    private final Boolean employee;

    private PermsFlagEnum(Integer level, String name, String permsFlag, Boolean rootManager, Boolean manager, Boolean departmentManager, Boolean employee) {
        this.level = level;
        this.name = name;
        this.permsFlag = permsFlag;
        this.rootManager = rootManager;
        this.manager = manager;
        this.departmentManager = departmentManager;
        this.employee = employee;
    }

    public Integer getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String getPermsFlag() {
        return this.permsFlag;
    }

    public Boolean getRootManager() {
        return this.rootManager;
    }

    public Boolean getManager() {
        return this.manager;
    }

    public Boolean getDepartmentManager() {
        return this.departmentManager;
    }

    public Boolean getEmployee() {
        return this.employee;
    }

    public static Set<PermsFlagEnum> getPermsFlagEnumByRoleLevel(final RoleLevelEnum roleLevelEnum) {
        HashSet permsFlags = Sets.newHashSet();
        if (roleLevelEnum == null) {
            return permsFlags;
        }
        return Arrays.stream(PermsFlagEnum.values()).filter(new Predicate<PermsFlagEnum>(){

            @Override
            public boolean test(PermsFlagEnum permsFlagEnum) {
                Boolean result;
                switch (roleLevelEnum) {
                    case ROOT_MANAGER: {
                        result = permsFlagEnum.getRootManager();
                        break;
                    }
                    case MANAGER: {
                        result = permsFlagEnum.getManager();
                        break;
                    }
                    case DEPARTMENT_MANAGER: {
                        result = permsFlagEnum.getDepartmentManager();
                        break;
                    }
                    case EMPLOYEE: {
                        result = permsFlagEnum.getEmployee();
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                return result;
            }
        }).collect(Collectors.toSet());
    }

    public static Set<String> getPermsFlagByRoleLevel(RoleLevelEnum roleLevelEnum) {
        HashSet permsFlags = Sets.newHashSet();
        if (roleLevelEnum == null) {
            return permsFlags;
        }
        return PermsFlagEnum.getPermsFlagEnumByRoleLevel(roleLevelEnum).stream().map(PermsFlagEnum::getPermsFlag).collect(Collectors.toSet());
    }
}

