package cn.com.duiba.scrm.center.api.dto.job;

import cn.com.duiba.scrm.common.enums.db.job.JobTimeUnitEnum;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/9/8
 */
@Builder
@Getter
@Setter
public class JobTimeConfig implements Serializable {

    private static final long serialVersionUID = -1228802595895083256L;

    private static String splitSendTime = ":";

    /**
     * 延迟时间（分钟）
     */
    private Integer laterTime;

    /**
     * 时间制定点（周一、一号等）
     */
    private Integer timeIndex;

    /**
     * 小时 天 周 月 JobTimeUnitEnum
     */
    private Integer timeUnit;

    /**
     * 发送时间（几点几分）HH:mm
     */
    private String sendTime;


    /**
     * 获取下个周期时间
     *
     * @return
     */
    public Date getNextPeriodDate() {

        if (Objects.isNull(this.sendTime) || this.sendTime.split(splitSendTime).length < 1) {
            return new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (JobTimeUnitEnum.HOUR.getType().equals(this.timeUnit)) {
            calendar.add(Calendar.HOUR_OF_DAY, 1);
            calendar.set(Calendar.MINUTE, Integer.parseInt(this.sendTime.split(splitSendTime)[1]));
            setCalendarSecond(calendar);

        } else if (JobTimeUnitEnum.DAY.getType().equals(this.timeUnit)) {
            calendar.add(Calendar.DAY_OF_YEAR, 1);
            calendar.set(Calendar.HOUR_OF_DAY, Integer.parseInt(this.sendTime.split(splitSendTime)[0]));
            calendar.set(Calendar.MINUTE, Integer.parseInt(this.sendTime.split(splitSendTime)[1]));
            setCalendarSecond(calendar);
        } else if (JobTimeUnitEnum.WEEK.getType().equals(this.timeUnit)) {
            calendar.add(Calendar.WEEK_OF_YEAR, 1);
            calendar.set(Calendar.DAY_OF_WEEK, this.timeIndex);
            calendar.set(Calendar.HOUR_OF_DAY, Integer.parseInt(this.sendTime.split(splitSendTime)[0]));
            calendar.set(Calendar.MINUTE, Integer.parseInt(this.sendTime.split(splitSendTime)[1]));
            setCalendarSecond(calendar);
        } else if (JobTimeUnitEnum.MONTH.getType().equals(this.timeUnit)) {
            calendar.add(Calendar.MONTH, 1);
            calendar.set(Calendar.DAY_OF_MONTH, this.timeIndex);
            calendar.set(Calendar.HOUR_OF_DAY, Integer.parseInt(this.sendTime.split(splitSendTime)[0]));
            calendar.set(Calendar.MINUTE, Integer.parseInt(this.sendTime.split(splitSendTime)[1]));
            setCalendarSecond(calendar);
        }

        return calendar.getTime();
    }

    /**
     * 秒数归零
     *
     * @param calendar
     */
    private void setCalendarSecond(Calendar calendar) {
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
    }

    /**
     * 获取定时发送的时间
     *
     * @return
     */
    public Date getAssignDate(Date date) {

        if (Objects.isNull(this.laterTime)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (JobTimeUnitEnum.HOUR.getType().equals(this.timeUnit)) {
            calendar.add(Calendar.HOUR_OF_DAY, this.timeIndex);
            calendar.add(Calendar.MINUTE, laterTime);
            setCalendarSecond(calendar);

        } else if (JobTimeUnitEnum.DAY.getType().equals(this.timeUnit)) {
            calendar.add(Calendar.DAY_OF_YEAR, this.timeIndex);
            calendar.add(Calendar.MINUTE, laterTime);
            setCalendarSecond(calendar);
        }

        return calendar.getTime();
    }

    public JobTimeConfig(Integer laterTime, Integer timeIndex, Integer timeUnit, String sendTime) {
        this.laterTime = laterTime;
        this.timeIndex = timeIndex;
        this.timeUnit = timeUnit;
        this.sendTime = sendTime;
    }

}

