package cn.com.duiba.scrm.center.api.remoteservice.groupmsg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.groupmsg.GroupMsgSendResultDto;
import cn.com.duiba.scrm.center.api.dto.groupmsg.GroupMsgTaskDto;
import cn.com.duiba.scrm.center.api.param.groupmsg.GroupMsgTaskQueryParam;
import cn.com.duiba.scrm.center.api.param.groupmsg.GroupMsgTaskSendResultQueryParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;
import java.util.Map;

/**
* 成员发送任务表 RemoteService
* @author xiaotian
* 2021-7-30 13:39:37
*/
@AdvancedFeignClient
public interface RemoteGroupMsgTaskService {
    /**
    * 新增记录
    */
    @Deprecated
	Boolean save(GroupMsgTaskDto dto);

    /**
    * 根据id删除
    */
    @Deprecated
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    @Deprecated
    Boolean updateById(GroupMsgTaskDto dto);
    /**
    * 根据id获取
    */
    @Deprecated
    GroupMsgTaskDto getById(Long id);

    /**
     * 根据查询条件统计数据
     * @param groupMsgTaskQueryParam ScrmResult<Long>
     * @return ScrmResult<Long>
     */
    ScrmResult<Map<Long, Long>> countByParam(GroupMsgTaskQueryParam groupMsgTaskQueryParam);

    /**
     * 根据筛选条件查询
     */
    ScrmResult<List<GroupMsgTaskDto>> getByParam(GroupMsgTaskQueryParam param);
}
