package cn.com.duiba.scrm.center.api.remoteservice.sop;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.sop.SopChatGroupCount;
import cn.com.duiba.scrm.center.api.dto.sop.SopChatGroupDto;
import cn.com.duiba.scrm.center.api.param.sop.group.SopQueryParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;
import java.util.Map;

/**
* 群sop与群聊关联表 RemoteService
* @author xiaotian
* 2021-9-2 10:18:21
*/
@AdvancedFeignClient
public interface RemoteSopChatGroupService {
    /**
    * 新增记录
    */
	Boolean save(SopChatGroupDto dto);

    /**
     * 根据id更新
     */
    Boolean updateById(SopChatGroupDto dto);

    /**
     * 根据id获取
     */
    SopChatGroupDto getById(Long id);

    ScrmResult<List<SopChatGroupCount>> getSopChatGroupCount(List<Long> sopGroupIds);


    /**
     * 根据sopId，获取绑定群聊列表
     *
     * @param sopQueryParam
     * @return
     */
    ScrmResult<ScrmPageResult<SopChatGroupDto>> queryPage(SopQueryParam sopQueryParam);


    /**
     * 根据群聊Id列表，获取当前绑定的sop
     *
     * @param chatGroupIds
     * @return
     */
    ScrmResult<Map<Long, List<SopChatGroupDto>>> getCountByChatGroupIds(List<Long> chatGroupIds);

}
