package cn.com.duiba.scrm.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.tag.TagDto;
import cn.com.duiba.scrm.center.api.dto.tag.TagGroupDetailDto;
import cn.com.duiba.scrm.center.api.param.TagDeleteParam;
import cn.com.duiba.scrm.center.api.param.TagEditParam;
import cn.com.duiba.scrm.center.api.param.TagQueryParam;
import cn.com.duiba.scrm.center.api.param.TagSaveParam;
import cn.com.duiba.scrm.center.api.param.tag.MakeTagSeriesParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 企业微信标签 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 19:23:53
 */
@AdvancedFeignClient
public interface RemoteTagService {
    @Deprecated
    List<TagDto> getByIds(List<Long> ids);

    @Deprecated
    List<TagDto> getByTagIds(Long scCorpId, List<String> tagIds);


    ScrmResult<ScrmPageResult<TagDto>> queryPage(TagQueryParam queryParam);


    /*----------------------以下三个接口均为先调用微信接口，再进行标签同步------------------------------*/
    ScrmResult<TagGroupDetailDto> addTag(TagSaveParam param);

    ScrmResult<Boolean> editTag(TagEditParam param);

    ScrmResult<Boolean> delTag(TagDeleteParam param);

    /*----------------------以下三个接口均为本地标签操作接口------------------------------*/

    /**
     * 新增，修改
     *
     * @param param
     * @return
     */
    ScrmResult<TagGroupDetailDto> addTagSeries(TagSaveParam param);

    /**
     * 删除标签，标签组
     *
     * @param param
     * @return
     */
    ScrmResult<Boolean> delTagSeries(TagDeleteParam param);

    /**
     * 打标签
     *
     * @param makeTagSeriesParam
     * @return
     */
    ScrmResult<Boolean> markTag(MakeTagSeriesParam makeTagSeriesParam);

    /**
     * 根据ID获取标签列表
     *
     * @param ids
     * @return
     */
    ScrmResult<List<TagDto>> getByIdsWithResult(List<Long> ids);
}
