package cn.com.duiba.scrm.center.api.remoteservice.wechatSync;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.enums.TagWechatTypeEnum;
import cn.com.duiba.scrm.common.enums.SuiteMessageChangeTypeEnum;
import cn.com.duiba.scrm.common.result.ScrmResult;

/**
 * @author wangxukai
 * @description 应用授权相关接口
 * @date ：Created in 2021/7/12
 */
@AdvancedFeignClient
public interface RemoteWehatSyncSerivce {

    /*------------------------------全量同步企业信息----------------------------------*/

    /**
     * 同步企业信息（全量）
     *
     * @param scCorpId
     * @returnRedisKeyFactory
     */
    ScrmResult<Boolean> syncCompany(Long scCorpId);

    /**
     * 同步企业部门（全量）
     *
     * @param scCorpId
     * @returnRedisKeyFactory
     */
    ScrmResult<Boolean> syncDepartment(Long scCorpId);

    /**
     * 同步成员（全量）
     *
     * @param scCorpId
     * @return
     */
    ScrmResult<Boolean> syncUser(Long scCorpId);


    /**
     * 同步客户（全量）
     *
     * @param scCorpId
     * @return
     */
    ScrmResult<Boolean> syncCustomer(Long scCorpId);


    /**
     * 同步群聊（全量）
     *
     * @param scCorpId
     * @return
     */
    ScrmResult<Boolean> syncChatGroup(Long scCorpId);


    /**
     * 同步标签（全量）（异步 + redis锁）
     *
     * @param scCorpId
     * @return
     */
    ScrmResult<Boolean> syncAllTag(Long scCorpId);


    /**
     * 同步第三方授权状态（异步 + redis锁）
     * @param scCorpId
     * @return
     */
    ScrmResult<Boolean> syncThirdAuth(Long scCorpId);


    /*------------------------------全量同步企业信息----------------------------------*/


    /*------------------------------同步单个成员信息----------------------------------*/

    /**
     * 同步单个成员信息（异步 + redis锁）
     * @param scCorpId  企业Id
     * @param wxchatUserId  成员企业userid
     * @param suiteMessageChangeTypeEnum 事件类型
     * @param async 是否需要异步
     * @return
     */
    ScrmResult<Boolean> syncSingleUser(Long scCorpId, String wxchatUserId, String newUserId,SuiteMessageChangeTypeEnum suiteMessageChangeTypeEnum,boolean async);

    /**
     * 同步单个成员授权信息
     * @param scCorpId  企业Id
     * @param wxchatUserId  成员企业userid
     * @return
     */
    ScrmResult<Boolean> syncSingleUserAuth(Long scCorpId, String wxchatUserId);

    /*------------------------------同步单个成员信息----------------------------------*/

    /*------------------------------同步单个客户信息----------------------------------*/

    /**
     * 同步单个客户信息（异步 + redis锁）
     * @param scCorpId
     * @param wxchatUserId
     * @param customerUserId
     * @param suiteMessageChangeTypeEnum
     * @param async 是否需要异步
     * @return
     */
    ScrmResult<Boolean> syncSingleCustomer(Long scCorpId, String wxchatUserId, String customerUserId,SuiteMessageChangeTypeEnum suiteMessageChangeTypeEnum,boolean async);

    /*------------------------------同步单个客户信息----------------------------------*/


    /*------------------------------同步群聊信息----------------------------------*/

    /**
     * 同步单个客户群信息（异步 + redis锁）
     * @param scCorpId
     * @param chatId
     * @param suiteMessageChangeTypeEnum
     * @return
     */
    ScrmResult<Boolean> syncSingleGroup(Long scCorpId, String chatId,SuiteMessageChangeTypeEnum suiteMessageChangeTypeEnum);

    /*------------------------------同步群聊信息----------------------------------*/


    /*------------------------------同步标签信息----------------------------------*/


    /**
     * 同步单个标签/标签组信息
     * @param scCorpId
     * @param tagWechatTypeEnum
     * @param id 标签id或者标签组id
     * @param suiteMessageChangeTypeEnum
     * @return
     */
    ScrmResult<Boolean> syncSingleTagOrGroup(Long scCorpId, TagWechatTypeEnum tagWechatTypeEnum, String id, SuiteMessageChangeTypeEnum suiteMessageChangeTypeEnum);

    /*------------------------------同步标签信息----------------------------------*/


    /*-----------------------------群发信息----------------------------------*/


    /**
     * 通过群发任务Id，同步群发信息
     * @param taskId
     * @return
     */
    @Deprecated
    boolean syncGroupMsg(Long taskId);

    /*------------------------------群发信息----------------------------------*/
}
