package cn.com.duiba.scrm.center.api.dto.code;

import cn.com.duiba.scrm.center.api.dto.BaseTagDto;
import cn.com.duiba.scrm.center.api.dto.material.BaseMaterialDto;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/24
 */
@Getter
@Setter
public class BaseEmpleCodeDto implements Serializable {
    private static final long serialVersionUID = 6013330974442466803L;
    /**
     * 活码表id ，有则更新，没有为新增
     */
    private Long id;
    /**
     * 二维码名称
     */
    private String codeName;
    /**
     * 二维码链接
     */
    private String qrCodeUrl;

    /**
     * 用户id列表
     */
    private List<Long> scUserIds;

    /**
     * 部门id列表
     */
    private List<Long> scDeptIds;
    /**
     * 标签id列表
     */
    private List<BaseTagDto> tagId;

    /**
     * 创建者
     */
    private Long createBy;

    /**
     * 企微信息id
     */
    private Long scCorpId;

    /**
     * 1、个人，2、群
     */
    private Integer useType;

    /**
     * 自动添加好友 0:跳过  1：不跳过
     */
    private Integer skipVerify;

    /**
     * 欢迎语类型
     */
    private Integer welcomeType;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 欢迎语详情
     */
    private List<BaseMaterialDto> materials;



    /**
     * 添加微信用户id
     */
    private List<String> wechatUserId;

}
