package cn.com.duiba.scrm.center.api.dto.operationLog;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 管理平台操作日志记录
* 2021-8-7 14:43:43
*/
@Data
public class OperLogManageDto implements Serializable {

    /**
    * 日志主键
    */
    private Long id;

    /**
    * 类型
    */
    private String partTitle;

    /**
    * 操作行为
    */
    private String businessType;

    /**
    * 方法名称
    */
    private String methodName;

    /**
    * 请求方式
    */
    private String requestMethod;

    /**
    * 操作人员
    */
    private Long userId;

    /**
    * 请求URL
    */
    private String operUrl;

    /**
    * 主机地址
    */
    private String operIp;

    /**
    * 请求参数
    */
    private String operParam;

    /**
    * 返回参数
    */
    private String jsonResult;

    /**
    * 操作状态（0正常 1异常）
    */
    private Integer operStatus;

    /**
    * 错误消息
    */
    private String errorMsg;

    /**
    * 操作时间
    */
    private Date operTime;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


}

