package cn.com.duiba.scrm.center.api.param.groupmsg;

import cn.com.duiba.scrm.center.api.param.BaseOperateParam;

import java.util.Date;
import java.util.List;

/**
 * 功能描述：创建客户群发、群群发参数
 *
 * @author yuanzhixin
 * @date 2021/7/30 14:34
 * @description:
 */
public class GroupMsgParam extends BaseOperateParam {

    private static final long serialVersionUID = 5680929106317924918L;
    /**
     * 群发名称
     */
    private String groupMsgName;

    /**
     * 用户列表
     */
    private List<Long> scUserIds;

    /**
     * 部门id列表
     */
    private List<Long> scDeptIds;

    /**
     * 选择客户
     */
    private CustomerParam customerParam;

    /**
     * 排除客户
     */
    private ExcludeCustomerParam excludeCustomerParam;

    /**
     * 附件
     */
    private List<BaseMaterialVo> materials;

    /**
     * single 为群发任务，group 为群群发任务
     */
    private String chatType;

    /**
     * 群发类型，1 立即发送，2 定时发送
     */
    private Integer sendType;

    /**
     * 发送时间，如果是立即发送传空，定时发送传对应的时间
     */
    private Date sendTime;

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Integer getSendType() {
        return sendType;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public String getChatType() {
        return chatType;
    }

    public void setChatType(String chatType) {
        this.chatType = chatType;
    }

    public String getGroupMsgName() {
        return groupMsgName;
    }

    public void setGroupMsgName(String groupMsgName) {
        this.groupMsgName = groupMsgName;
    }

    public CustomerParam getCustomerParam() {
        return customerParam;
    }

    public void setCustomerParam(CustomerParam customerParam) {
        this.customerParam = customerParam;
    }

    public ExcludeCustomerParam getExcludeCustomerParam() {
        return excludeCustomerParam;
    }

    public void setExcludeCustomerParam(ExcludeCustomerParam excludeCustomerParam) {
        this.excludeCustomerParam = excludeCustomerParam;
    }

    public List<BaseMaterialVo> getMaterials() {
        return materials;
    }

    public void setMaterials(List<BaseMaterialVo> materials) {
        this.materials = materials;
    }

    public List<Long> getScUserIds() {
        return scUserIds;
    }

    public void setScUserIds(List<Long> scUserIds) {
        this.scUserIds = scUserIds;
    }

    public List<Long> getScDeptIds() {
        return scDeptIds;
    }

    public void setScDeptIds(List<Long> scDeptIds) {
        this.scDeptIds = scDeptIds;
    }
}
