package cn.com.duiba.scrm.center.api.param.groupmsg;

import cn.com.duiba.scrm.center.api.param.BaseOperateParam;

import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description: 群组、群群组基础信息参数
 * @date 2021/7/30 19:55
 */
public class GroupMsgQueryParam extends BaseOperateParam {

    private static final long serialVersionUID = -6301297642299948821L;
    /**
     * 查询条件
     */
    private String bizParam;

    /**
     * 群发任务类型，默认为single, single 表示发送给客户，group 表示发送给客户群
     */
    private String chatType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 群发名称
     */
    private String groupMsgName;

    /**
     * 状态，1 发送成功，2 待发送，3 创建失败，4 已取消（初始状态为待发送）5 发送中
     */
    private Integer groupMsgStatus;

    /**
     * 群发类型，1 立即发送，2 定时发送
     */
    private Integer groupMsgType;

    /**
     * 主键id，自增
     */
    private Long id;

    /**
     * 修改人ID:sc_user.id
     */
    private Long modifiedBy;

    /**
     * 发送时间
     */
    private Date sendTime;

    /**
     * 错误原因
     */
    private String errorMsg;

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getBizParam() {
        return bizParam;
    }

    public void setBizParam(String bizParam) {
        this.bizParam = bizParam;
    }

    public String getChatType() {
        return chatType;
    }

    public void setChatType(String chatType) {
        this.chatType = chatType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getGroupMsgName() {
        return groupMsgName;
    }

    public void setGroupMsgName(String groupMsgName) {
        this.groupMsgName = groupMsgName;
    }

    public Integer getGroupMsgStatus() {
        return groupMsgStatus;
    }

    public void setGroupMsgStatus(Integer groupMsgStatus) {
        this.groupMsgStatus = groupMsgStatus;
    }

    public Integer getGroupMsgType() {
        return groupMsgType;
    }

    public void setGroupMsgType(Integer groupMsgType) {
        this.groupMsgType = groupMsgType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getModifiedBy() {
        return modifiedBy;
    }

    public void setModifiedBy(Long modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }
}
