package cn.com.duiba.scrm.center.api.param.groupmsg;

import cn.com.duiba.scrm.center.api.param.BaseOperateParam;

import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description: 基础筛选条件
 * @date 2021/7/30 15:32
 */
public class MsgBaseCustomerParam extends BaseOperateParam {

    private static final long serialVersionUID = -7922726333799434822L;
    /**
     * 性别 0 未知性别，1 仅男性粉丝，2 仅女性粉丝，3为全部性别
     */
    private Integer genderType;

    /**
     * 所在群聊
     */
    private List<String> groups;

    /**
     * 0 表示全部群组, 1表示已入群，2表示未入群
     */
    private Integer allGroup;

    /**
     * 添加时间-开始日期
     */
    private Long start;

    /**
     * 添加时间-结束日期
     */
    private Long end;

    /**
     * 企微客户标签
     */
    private List<Long> tags;

    /**
     * 是否取并集，true 表示且，false 表示或
     */
    private Boolean union;

    public Integer getAllGroup() {
        return allGroup;
    }

    public void setAllGroup(Integer allGroup) {
        this.allGroup = allGroup;
    }

    public Boolean getUnion() {
        return union;
    }

    public void setUnion(Boolean union) {
        this.union = union;
    }

    public Integer getGenderType() {
        return genderType;
    }

    public void setGenderType(Integer genderType) {
        this.genderType = genderType;
    }

    public Long getStart() {
        return start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public Long getEnd() {
        return end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public List<String> getGroups() {
        return groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public List<Long> getTags() {
        return tags;
    }

    public void setTags(List<Long> tags) {
        this.tags = tags;
    }
}
