package cn.com.duiba.scrm.center.api.remoteservice.chatgroup;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.chatgroup.ChatGroupDetailDto;
import cn.com.duiba.scrm.center.api.dto.chatgroup.ChatGroupDto;
import cn.com.duiba.scrm.center.api.dto.chatgroup.ChatGroupStatisticDto;
import cn.com.duiba.scrm.center.api.param.chatgroup.ChatGroupDetailParam;
import cn.com.duiba.scrm.center.api.param.chatgroup.ChatGroupQueryParam;
import cn.com.duiba.scrm.center.api.param.chatgroup.ChatGroupStatisticParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 企业微信群 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 13:52:14
 */
@AdvancedFeignClient
public interface RemoteChatGroupService {
    /**
     * 新增记录
     */
    @Deprecated
    Long save(ChatGroupDto dto);

    /**
     * 根据id删除
     */
    @Deprecated
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    @Deprecated
    Boolean updateById(ChatGroupDto dto);

    /**
     * 根据id获取
     */
    @Deprecated
    ChatGroupDto getById(Long id);


    /**
     * 查询客户群
     */
    ScrmResult<ScrmPageResult<ChatGroupDto>> queryPage(ChatGroupQueryParam param);


    ScrmResult<ChatGroupDetailDto> detail(ChatGroupDetailParam param);

    /**
     * 批量统计多个群的指定日期的统计
     */
    ScrmResult<List<ChatGroupStatisticDto>> statistic(ChatGroupStatisticParam param);

    /*
     * 根据企业Id和chatId列表，获取群列表
     * @param scCorpId
     * @param chatIds
     * @return
     */
    @Deprecated
    List<ChatGroupDto>  getByCorpIdAndChatIdList(Long scCorpId, List<String> chatIds);


    /*
     * 根据企业Id，获取群列表
     * @param scCorpId
     * @param chatIds
     * @return
     */
    @Deprecated
    List<ChatGroupDto>  getByCorpId(Long scCorpId);


    /**
     * 统计客户群数量
     * @param chatGroupQueryParam
     * @return
     */
    @Deprecated
    Long countByParam(ChatGroupQueryParam chatGroupQueryParam);

    /**
     * 根据群主查询
     * @param scCorpId
     * @param scUserId
     * @return
     */
    @Deprecated
    List<ChatGroupDto> getByScUserId(Long scCorpId, Long scUserId);

    /**
     * 根据群主数组查询
     * @param scCorpId
     * @param scUserIds
     * @return
     */
    @Deprecated
    List<ChatGroupDto> getByScUserIds(Long scCorpId, List<Long> scUserIds);
}
