package cn.com.duiba.scrm.center.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.customer.WechatCustomerDto;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
* 企业微信客户表 RemoteService
* @author xiaotian
* 2021-7-23 15:35:19
*/
@AdvancedFeignClient
public interface RemoteWechatCustomerService {
    /**
    * 新增记录
    */
    @Deprecated
	Long save(WechatCustomerDto dto);

    /**
    * 根据id删除
    */
    @Deprecated
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    @Deprecated
    Boolean updateById(WechatCustomerDto dto);
    /**
    * 根据id获取
    */
    @Deprecated
    WechatCustomerDto getById(Long id);


    /**
     * 通过企业Id和客户id列表获取
     *
     * @param scCorpId
     * @param customerIds
     * @return
     */
    @Deprecated
    List<WechatCustomerDto> getByCorpIdAndIds(Long scCorpId, List<Long> customerIds);

    /**
     * 通过企业Id和客户id列表获取
     *
     * @param scCorpId
     * @param customerIds
     * @return
     */
    ScrmResult<List<WechatCustomerDto>> getByCorpIdAndIdsWithResult(Long scCorpId, List<Long> customerIds);

    /**
     * 通过企业Id和客户id列表获取
     *
     * @param scCorpId
     * @param customerIds
     * @return
     */
    @Deprecated
    List<WechatCustomerDto> getByCorpIdAndCustomerUserIds(Long scCorpId, List<String> customerIds);

    /**
     * 通过外部联系人的userid查询
     *
     * @param externalUserId
     * @return
     */
    ScrmResult<WechatCustomerDto> getByExternalUserId(Long scCorpId, String externalUserId);

    /**
     * 根据名称获取客户
     *
     * @param scCorpId
     * @param name
     * @return
     */
    ScrmResult<List<WechatCustomerDto>> getByCorpIdAndName(Long scCorpId, String name);
}
