package cn.com.duiba.scrm.center.api.remoteservice.emple;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.emple.EmpleBizDto;
import cn.com.duiba.scrm.common.enums.db.BizTypeEnum;
import cn.com.duiba.scrm.common.enums.db.emple.EmpleTypeEnum;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 员工与其他业务关联表 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 10:33:44
 */
@AdvancedFeignClient
public interface RemoteEmpleBizService {
    /**
     * 新增记录
     */
    @Deprecated
    Boolean save(EmpleBizDto dto);

    @Deprecated
    Integer saveBatch(List<EmpleBizDto> dtos);

    /**
     * 根据id删除
     */
    @Deprecated
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    @Deprecated
    Boolean updateById(EmpleBizDto dto);

    /**
     * 根据id获取
     */
    @Deprecated
    EmpleBizDto getById(Long id);


    /**
     * 根据条件获取员工列表
     *
     * @param dto
     * @return
     */
    ScrmResult<List<EmpleBizDto>> getByDto(EmpleBizDto dto);

    ScrmResult<List<EmpleBizDto>> getByBizIds(BizTypeEnum type, List<Long> bizIds);

    ScrmResult<Integer> delByBizId(BizTypeEnum type, Long bizId);

    ScrmResult<List<Long>>  getBizIdsByUserIds(BizTypeEnum bizTypeEnum, EmpleTypeEnum empleTypeEnum,List<Long> userIds);



}
