package cn.com.duiba.scrm.center.api.remoteservice.pharse;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.shorcut.ShortcutPhraseDto;
import cn.com.duiba.scrm.center.api.dto.shorcut.ShortcutPhraseGroupDto;
import cn.com.duiba.scrm.center.api.param.BaseOperateParam;
import cn.com.duiba.scrm.center.api.param.phrase.ShortCutPhraseExcelParam;
import cn.com.duiba.scrm.center.api.param.phrase.ShortCutPhraseMaterailParam;
import cn.com.duiba.scrm.center.api.param.phrase.ShortCutPhraseQueryParam;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 素材库-话术库
 */
@AdvancedFeignClient
public interface RemotePharseMaterailService {


    /**
     * 创建话术，以及其下面的子素材
     * @param shortCutPhraseMaterailParam
     * @return
     */
    ScrmResult<Long> createNewPharseMaterail(ShortCutPhraseMaterailParam shortCutPhraseMaterailParam);

    /**
     * 更新话术以及其下面的子素材
     * @param shortCutPhraseMaterailParam
     * @return
     */
    ScrmResult<Boolean> updatePharseMaterail(ShortCutPhraseMaterailParam shortCutPhraseMaterailParam);

    /**
     * 更新话术以及其下面的子素材
     * @param shortCutPhraseMaterailParam
     * @return
     */
    ScrmResult<ScrmPageResult<ShortcutPhraseDto>>  queryPharseMaterail(ShortCutPhraseQueryParam param);

    /**
     * 话术素材批量处理
     * @param param
     * @return
     */
    ScrmResult<Boolean> batchDealMaterail(ShortCutPhraseExcelParam param);

    /**
     * 话术组及内容数量查询
     * @param param
     * @return
     */
    ScrmResult<List<ShortcutPhraseGroupDto>> queryGroupPharseCount(BaseOperateParam param);
}
