package cn.com.duiba.scrm.center.api.remoteservice.radar;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.radar.ClickDataByChannelDto;
import cn.com.duiba.scrm.center.api.dto.radar.ClickNumByCustomerDto;
import cn.com.duiba.scrm.center.api.dto.radar.ClickRankDataByChannelDto;
import cn.com.duiba.scrm.center.api.dto.radar.ClickUsersByRadarDto;
import cn.com.duiba.scrm.center.api.dto.radar.RadarLogCustomerQueryDto;
import cn.com.duiba.scrm.center.api.dto.radar.RadarLogDto;
import cn.com.duiba.scrm.center.api.param.social.radar.ClickNumByCustomerQueryParam;
import cn.com.duiba.scrm.center.api.param.social.radar.ClickRankDataByChannelQueryParam;
import cn.com.duiba.scrm.center.api.param.social.radar.ClickUsersByChannelQueryParam;
import cn.com.duiba.scrm.center.api.param.social.radar.ClickUsersByRadarQueryParam;
import cn.com.duiba.scrm.center.api.param.social.radar.CustomerClickPageQueryParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 点击雷达记录表 RemoteService
 *
 * @author xiaotian
 * 2021-8-26 10:49:23
 */
@AdvancedFeignClient
public interface RemoteRadarLogService {
    /**
     * 新增记录
     */
    Boolean save(RadarLogDto dto);

    /**
     * 根据id更新
     */
    Boolean updateById(RadarLogDto dto);

    /**
     * 根据id获取
     */
    RadarLogDto getById(Long id);


    /**
     * 批量统计雷达链接点击人数/次数
     *
     * @param queryParam
     * @return
     */
    ScrmResult<List<ClickUsersByRadarDto>> clickUsersByRadar(ClickUsersByRadarQueryParam queryParam);

    /**
     * 统计渠道点击数据
     *
     * @param queryParam
     * @return
     */
    ScrmResult<List<ClickDataByChannelDto>> clickDataByChannel(ClickUsersByChannelQueryParam queryParam);

    /**
     * 按渠道统计排行榜
     *
     * @param queryParam
     * @return
     */
    ScrmResult<List<ClickRankDataByChannelDto>> clickRankDataByChannel(ClickRankDataByChannelQueryParam queryParam);

    /**
     * 按客户统计点击次数
     *
     * @param queryParam
     * @return
     */
    ScrmResult<List<ClickNumByCustomerDto>> clickNumByCustomer(ClickNumByCustomerQueryParam queryParam);

    /**
     * 按员工查询
     *
     * @param queryParam
     * @return
     */
    ScrmResult<Long> countCustomerClick(CustomerClickPageQueryParam queryParam);

    /**
     * 按员工查询  员工点击记录
     *
     * @param queryParam
     * @return
     */
    ScrmResult<List<RadarLogCustomerQueryDto>> pageQueryCustomerClick(CustomerClickPageQueryParam queryParam);


    /**
     * 按员工统计， 员工列表
     *
     * @param queryParam
     * @return
     */
    ScrmResult<List<Long>> pageUserCustomerClick(CustomerClickPageQueryParam queryParam);

    /**
     * 按员工统计 员工数量
     *
     * @param queryParam
     * @return
     */
    ScrmResult<Long> countUserCustomerClick(CustomerClickPageQueryParam queryParam);
}
