package cn.com.duiba.scrm.center.api.remoteservice.sop;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.sop.SopGroupDto;
import cn.com.duiba.scrm.center.api.param.sop.group.SopGroupSaveParam;
import cn.com.duiba.scrm.center.api.param.sop.group.SopGroupUpdateStatusParam;
import cn.com.duiba.scrm.common.result.ScrmResult;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 群sop主表 RemoteService
 *
 * @author xiaotian
 * 2021-9-2 10:18:20
 */
@AdvancedFeignClient
public interface RemoteSopGroupService {
    /**
     * 新增记录
     */
    Boolean save(SopGroupDto dto);

    /**
     * 根据id更新
     */
    Boolean updateById(SopGroupDto dto);

    /**
     * 根据id获取
     */
    SopGroupDto getById(Long id);

    /**
     * 创建群sop
     *
     * @param param
     * @return
     */
    ScrmResult<Long> add(SopGroupSaveParam param);

    /**
     * 修改群sop
     *
     * @param param
     * @return
     */
    ScrmResult<Long> update(SopGroupSaveParam param);

    /**
     * 软删除群sop相关
     * 1.修改群sop状态为删除
     * 2.硬删除群sop与群聊之间的关联
     * 3.所有当前群sop的jobRule软删除
     *
     * @param sopGroupId
     * @return
     */
    ScrmResult<Long> del(Long sopGroupId, Long scUserId);

    /**
     * 群sop状态更改
     *
     * @param param
     * @return
     */
    ScrmResult<Long> updateStatus(SopGroupUpdateStatusParam param);


}
