package cn.com.duiba.scrm.center.api.dto.chatgroup;

import cn.com.duiba.scrm.center.api.dto.base.BaseDto;
import cn.com.duiba.scrm.center.api.enums.ChatAdminEnum;
import cn.com.duiba.scrm.center.api.enums.ChatMemerStatusEnum;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.CustomerGroupMemberResult;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * 企业微信群成员
 * 2021-7-24 13:53:01
 */
@Data
public class ChatGroupMemberDto implements BaseDto {

    private static final long serialVersionUID = -1865925344882773466L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 群成员id
     */
    private String userId;

    /**
     * 群id
     */
    private String chatId;

    /**
     * 外部联系人在微信开放平台的唯一身份标识
     */
    private String unionId;

    /**
     * 加群时间
     */
    private Date joinTime;

    /**
     * 离群时间，只有member_status=0时有效
     */
    private Date leaveTime;

    /**
     * 加入方式
     */
    private Integer joinScene;

    /**
     * 成员类型：0:成员 1:管理员 2:群主
     */
    private Integer chatAdmin;

    /**
     * 状态： 0:不在群 1:在群
     */
    private Integer memberStatus;

    /**
     * 成员类型:1 - 企业成员;2 - 外部联系人
     */
    private Integer memberType;

    /**
     * 名字。仅当 need_name = 1 时返回,如果是微信用户，则返回其在微信中设置的名字,如果是企业微信联系人，则返回其设置对外展示的别名或实名
     */
    private String memberName;

    /**
     * 邀请者。目前仅当是由本企业内部成员邀请入群时会返回该值
     */
    private String invitorUserid;

    /**
     * 在群里的昵称
     */
    private String groupNickname;

    /**
     * 企业id
     */
    private Long scCorpId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;


    public static ChatGroupMemberDto convert(CustomerGroupMemberResult customerGroupMemberResult) {
        ChatGroupMemberDto chatGroupMemberDto = new ChatGroupMemberDto();
        chatGroupMemberDto.setGroupNickname(customerGroupMemberResult.getGroupNickname());
        if (Objects.nonNull(customerGroupMemberResult.getInvitor())) {
            chatGroupMemberDto.setInvitorUserid(customerGroupMemberResult.getInvitor().getUserid());
        }
        chatGroupMemberDto.setJoinScene(customerGroupMemberResult.getJoinScene());
        chatGroupMemberDto.setJoinTime(new Date(customerGroupMemberResult.getJoinTime() * 1000));
        chatGroupMemberDto.setMemberName(customerGroupMemberResult.getName());
        chatGroupMemberDto.setMemberType(customerGroupMemberResult.getType());
        chatGroupMemberDto.setUnionId(customerGroupMemberResult.getUnionid());
        chatGroupMemberDto.setUserId(customerGroupMemberResult.getUserid());
        //先默认成员，具体角色在外部变更
        chatGroupMemberDto.setChatAdmin(ChatAdminEnum.NOMAL.getCode());
        chatGroupMemberDto.setMemberStatus(ChatMemerStatusEnum.IN.getCode());
        return chatGroupMemberDto;
    }

    public static boolean diff(ChatGroupMemberDto old, ChatGroupMemberDto update) {
        return
                !(Objects.equals(old.getGroupNickname(), update.getGroupNickname())
                        &&
                        Objects.equals(old.getInvitorUserid(), update.getInvitorUserid())
                        &&
                        Objects.equals(old.getJoinScene(), update.getJoinScene())
                        &&
                        Objects.equals(old.getJoinTime(), update.getJoinTime())
                        &&
                        Objects.equals(old.getMemberName(), update.getMemberName())
                        &&
                        Objects.equals(old.getMemberType(), update.getMemberType())
                        &&
                        Objects.equals(old.getUnionId(), update.getUnionId())
                        &&
                        Objects.equals(old.getUserId(), update.getUserId())
                        &&
                        Objects.equals(old.getChatAdmin(), update.getChatAdmin())
                        &&
                        Objects.equals(old.getMemberStatus(), update.getMemberStatus())
                        &&
                        Objects.equals(old.getChatId(), update.getChatId())
                        &&
                        Objects.equals(old.getScCorpId(), update.getScCorpId()));
    }

}

