package cn.com.duiba.scrm.center.api.dto.tag;

import cn.com.duiba.scrm.center.api.dto.base.BaseDto;
import cn.com.duiba.scrm.common.enums.db.tag.TagTypeEnum;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer.WeCropGroupTagParamBean;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * 标签组
 * 2021-7-24 19:23:52
 */
@Data
public class TagGroupDto implements BaseDto {

    private static final long serialVersionUID = -4911129819014958335L;
    /**
     * 主键id，自增
     */
    private Long id;

    /**
     * 标签组id
     */
    private String groupId;

    /**
     * 标签组名称
     */
    private String groupName;

    /**
     * 状态（1正常 0删除）
     */
    private Integer groupStatus;

    /**
     * 标签组排序的次序值
     */
    private Integer groupOrder;

    /**
     * 创建人ID:sc_user.id
     */
    private Long createBy;

    /**
     * 企业id
     */
    private Long scCorpId;

    /**
     * 标签类型
     *
     * @see cn.com.duiba.scrm.common.enums.db.tag.TagTypeEnum
     */
    private Integer bizType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public static TagGroupDto convert(WeCropGroupTagParamBean weCropGroupTagParamBean) {
        TagGroupDto tagGroupDto = new TagGroupDto();
        tagGroupDto.setGroupName(weCropGroupTagParamBean.getGroupName());
        tagGroupDto.setGroupId(weCropGroupTagParamBean.getGroupId());
        tagGroupDto.setGroupOrder(weCropGroupTagParamBean.getOrder());
        tagGroupDto.setGroupStatus(Objects.isNull(weCropGroupTagParamBean.getDeleted()) ? null : weCropGroupTagParamBean.getDeleted() ? 0 : 1);
        tagGroupDto.setBizType(TagTypeEnum.QIWEI.getType());
        return tagGroupDto;
    }


}

