package cn.com.duiba.scrm.center.api.enums;

/**
 * @author 小天
 * @version 1.0.0
 * @ClassName UserAuthTypeEnum.java
 * @Description 成员授权状态状态 目前都只有自建应用范围内拉取的成员信息，
 * @createTime 2021年07月15日 10:54:00
 */
public enum UserAuthTypeEnum {
    @Deprecated
    NO(0,"未授权"),
    @Deprecated
    THIRD(1,"第三方授权"),
    SELF(2,"自建应用授权"),
    ALL(3,"都授权");


    private Integer type;

    private String desc;

    UserAuthTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static UserAuthTypeEnum getByType(Integer type){
        for (UserAuthTypeEnum userAuthTypeEnum : UserAuthTypeEnum.values()){
            if(type.equals(userAuthTypeEnum.getType())){
                return userAuthTypeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
