package cn.com.duiba.scrm.center.api.param;

import cn.com.duiba.scrm.center.api.dto.tag.TagDto;
import cn.com.duiba.scrm.center.api.param.tag.TagBaseOperateParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/7/27 20:43
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TagSaveParam extends TagBaseOperateParam {
    private static final long serialVersionUID = -74919745000411427L;

    /**
     * 标签组id
     * 如果要向指定的标签组下添加标签，需要填写 group_id 参数
     */
    private String groupId;

    /**
     * 如果要创建一个全新的标签组以及标签，则需要通过 group_name 参数指定新标签组名称
     * 如果填写的 groupname 已经存在，则会在此标签组下新建标签
     */
    private String groupName;

    @Deprecated
    private Integer order;


    private List<TagDto> tagList;

}
